/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.plugin.zip;

import com.browsersoft.commander.commanderwindow.plugin.zip.ZipUtils;
import com.browsersoft.commander.model.DirectoryFlavourElement;
import com.browsersoft.commander.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class ZipEntryDirectoryFlavourElement
implements DirectoryFlavourElement {
    private ZipEntry zipEntry;
    private File file;
    private String relative;

    public ZipEntryDirectoryFlavourElement(File file, ZipEntry zipEntry, String relative) {
        this.zipEntry = zipEntry;
        this.file = file;
        this.relative = relative;
    }

    @Override
    public InputStream openInputStream() throws Exception {
        if (!this.zipEntry.isDirectory()) {
            return ZipUtils.openInputStream(this.zipEntry, new FileInputStream(this.file));
        }
        return null;
    }

    @Override
    public int getType() {
        if (this.zipEntry.isDirectory()) {
            return 0;
        }
        return 1;
    }

    @Override
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public String getRelativePath() {
        return this.getRPath();
    }

    @Override
    public String getName() {
        return FileUtils.getNameFileFromURL(ZipUtils.getNameWithoutSlash(this.zipEntry.getName()));
    }

    private String getRPath() {
        String rel = this.zipEntry.getName().substring(this.relative.length());
        return ZipUtils.getNameWithoutSlash(rel);
    }
}

