/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.plugin.zip;

import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryExportDirectoryAndFileAction;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.Column;
import com.browsersoft.commander.model.adapter.ColumnName;
import com.browsersoft.commander.model.adapter.ColumnPosition;
import com.browsersoft.commander.model.adapter.ColumnRenderer;
import com.browsersoft.commander.model.adapter.ColumnSize;
import com.browsersoft.commander.model.adapter.renderer.DateCellRenderer;
import com.browsersoft.commander.model.adapter.renderer.SpacedNumberCellRenderer;
import com.browsersoft.commander.model.plugin.PublicTypeCollection;
import com.browsersoft.commander.model.plugin.WrappedFileFlavourPublicType;
import com.browsersoft.commander.utils.FileUtils;
import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ZipEntryFileAdapterItem
extends AdapterItem {
    private ZipEntry zipEntry;
    private File file;
    private DocumentManager documentManager;

    public ZipEntryFileAdapterItem(ZipEntry zipEntry, DocumentManager documentManager, File file) {
        this.zipEntry = zipEntry;
        this.file = file;
        this.documentManager = documentManager;
        Icon icon = documentManager.getIconForExtension(FileUtils.getExtension(zipEntry.getName()));
        if (icon == null) {
            icon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/filesystem/file.png"));
        }
        this.setIcon(icon);
    }

    @Override
    public String getId() {
        return this.zipEntry.getName();
    }

    @Override
    public String getName() {
        return FileUtils.getFileNameWithoutExtension(FileUtils.getNameFileFromURL(this.zipEntry.getName()));
    }

    @Column
    @ColumnPosition(value=0)
    @ColumnSize(value=50)
    @ColumnName(value="Ext")
    public String getExtension() {
        return FileUtils.getExtension(this.zipEntry.getName());
    }

    @Column
    @ColumnPosition(value=1)
    @ColumnSize(value=70)
    @ColumnName(value="Size")
    @ColumnRenderer(value=SpacedNumberCellRenderer.class)
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Column
    @ColumnPosition(value=2)
    @ColumnSize(value=70)
    @ColumnName(value="Date")
    @ColumnRenderer(value=DateCellRenderer.class)
    public long getDate() {
        return this.zipEntry.getTime();
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
    }

    @Override
    public PublicTypeCollection getPublicTypeCollection() throws Exception {
        PublicTypeCollection publicTypeCollection = new PublicTypeCollection();
        WrappedFileFlavourPublicType publicType = new WrappedFileFlavourPublicType(new ZipEntryExportDirectoryAndFileAction(this.file, new ZipFile(this.file)).exportItem(this), this.documentManager);
        publicTypeCollection.add(publicType);
        return publicTypeCollection;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

