/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.plugin.zip;

import com.browsersoft.commander.commanderwindow.plugin.zip.ZipUtils;
import com.browsersoft.commander.model.FileFlavour;
import com.browsersoft.commander.model.PreparingHandler;
import com.browsersoft.commander.utils.FileUtils;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class ZipEntryFileFlavour
extends FileFlavour {
    private File file;
    private ZipEntry zipEntry;

    public ZipEntryFileFlavour(File file, ZipEntry zipEntry) {
        this.file = file;
        this.zipEntry = zipEntry;
    }

    @Override
    public SizedInputStream openInputStream() throws Exception {
        InputStream inputStream = ZipUtils.openInputStream(this.zipEntry, new FileInputStream(this.file));
        return new SizedInputStream(inputStream, this.zipEntry.getSize());
    }

    @Override
    public int getNumberOfElements() {
        return 1;
    }

    @Override
    public String getName() {
        return FileUtils.getNameFileFromURL(this.zipEntry.getName());
    }

    @Override
    public long getByteSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public void prepare(PreparingHandler handler) throws Exception {
    }

    @Override
    public boolean hasLongPreparing() {
        return false;
    }
}

