/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.profiles;

import com.browsersoft.commander.commanderwindow.profiles.ProfileListener;
import com.browsersoft.commander.model.CommanderPlugStorage;
import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.DocumentManager;
import java.io.Serializable;

public class Profile
implements Serializable {
    private String profileName;
    private boolean autoConnect;
    private Object moduleConfiguration;
    private transient CommanderPlugStorage commanderPlugStorage;
    private transient CommanderPlugStorageModel commanderPlugStorageModel;
    private transient ProfileListener listener;

    public boolean isConnected() {
        return this.commanderPlugStorageModel != null;
    }

    public void connect(DocumentManager documentManager) throws Exception {
        CommanderPlugStorageModel newModel = this.commanderPlugStorage.createStorageModel(this.moduleConfiguration);
        newModel.setDocumentManager(documentManager);
        newModel.connect();
        this.commanderPlugStorageModel = newModel;
        if (this.listener != null) {
            this.listener.profilesChanged();
        }
    }

    public void disconnect() throws Exception {
        this.commanderPlugStorageModel.disconnect();
        this.commanderPlugStorageModel = null;
        if (this.listener != null) {
            this.listener.profilesChanged();
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public Object getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(Object moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public CommanderPlugStorage getCommanderPlugStorage() {
        return this.commanderPlugStorage;
    }

    public void setCommanderPlugStorage(CommanderPlugStorage commanderPlugStorage) {
        this.commanderPlugStorage = commanderPlugStorage;
    }

    public CommanderPlugStorageModel getCommanderPlugStorageModel() {
        return this.commanderPlugStorageModel;
    }

    public void setCommanderPlugStorageModel(CommanderPlugStorageModel commanderPlugStorageModel) {
        this.commanderPlugStorageModel = commanderPlugStorageModel;
    }

    public ProfileListener getListener() {
        return this.listener;
    }

    public void setListener(ProfileListener listener) {
        this.listener = listener;
    }
}

