/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.profiles;

import com.browsersoft.commander.commanderwindow.modules.BuildInPluginsManager;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfo;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfoCollection;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileCollection;
import com.browsersoft.commander.model.CommanderPlugStorage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class ProfilesNode {
    private static final String COUNT = "count";
    private static final String PROFILE_NAME = "profileName";
    private static final String PROFILE_CLASS = "profileClass";
    private static final String PROFILE_AUTO_CONNECT = "autoConnect";
    Preferences preferences;
    private String profilePrefix = "";

    public ProfilesNode(Class h) {
        this.preferences = Preferences.userNodeForPackage(h);
    }

    public void exportPreferences(String FilePath) throws BackingStoreException, IOException {
        this.preferences.exportSubtree(new FileOutputStream(FilePath));
    }

    public void importPreferences(String FilePath) throws IOException, InvalidPreferencesFormatException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(FilePath));
        Preferences.importPreferences(is);
    }

    public ProfileCollection load(StorageTypeInfoCollection storages) throws Exception {
        this.profilePrefix = BuildInPluginsManager.getProfilesPrefix();
        ArrayList<Profile> profilesList = new ArrayList<Profile>();
        int count = this.preferences.getInt(this.profilePrefix + COUNT, 0);
        for (int i = 0; i < count; ++i) {
            String storageClassName = this.preferences.get(this.profilePrefix + PROFILE_CLASS + "_" + i, "");
            for (int j = 0; j < storages.size(); ++j) {
                StorageTypeInfo storageTypeInfo = storages.get(j);
                if (!storageTypeInfo.getStorage().getClass().getName().equals(storageClassName)) continue;
                CommanderPlugStorage commanderStorage = storageTypeInfo.getStorage();
                Profile profile = new Profile();
                profile.setProfileName(this.preferences.get(this.profilePrefix + PROFILE_NAME + "_" + i, ""));
                profile.setAutoConnect(this.preferences.getBoolean(this.profilePrefix + PROFILE_AUTO_CONNECT + "_" + i, false));
                profile.setCommanderPlugStorage(commanderStorage);
                Object configuration = commanderStorage.createConfigurationObject();
                PropertyDescriptor[] properties = this.getObjectGetSetProperties(configuration.getClass());
                for (int k = 0; k < properties.length; ++k) {
                    this.loadProperty(properties[k], configuration, i);
                }
                profile.setModuleConfiguration(configuration);
                profilesList.add(profile);
            }
        }
        ProfileCollection profiles = new ProfileCollection();
        profiles.setProfiles(profilesList);
        return profiles;
    }

    public void save(ProfileCollection profiles) throws IntrospectionException, IllegalAccessException, InvocationTargetException, BackingStoreException {
        this.preferences.putInt(this.profilePrefix + COUNT, profiles.size());
        for (int i = 0; i < profiles.size(); ++i) {
            Profile profile = profiles.get(i);
            Object configuration = profile.getModuleConfiguration();
            this.preferences.put(this.profilePrefix + PROFILE_NAME + "_" + i, profile.getProfileName());
            this.preferences.put(this.profilePrefix + PROFILE_CLASS + "_" + i, profile.getCommanderPlugStorage().getClass().getName());
            this.preferences.putBoolean(this.profilePrefix + PROFILE_AUTO_CONNECT + "_" + i, profile.isAutoConnect());
            PropertyDescriptor[] properties = this.getObjectGetSetProperties(configuration.getClass());
            for (int j = 0; j < properties.length; ++j) {
                this.putProperty(properties[j], configuration, i);
            }
        }
    }

    private void loadProperty(PropertyDescriptor propertyDescriptor, Object configuration, int i) throws IllegalAccessException, InvocationTargetException {
        Class<?> propertyClass = propertyDescriptor.getPropertyType();
        String nameOfPreference = this.profilePrefix + propertyDescriptor.getName() + "_" + i;
        if (propertyClass.getName().equals(String.class.getName())) {
            String value = this.preferences.get(nameOfPreference, "");
            propertyDescriptor.getWriteMethod().invoke(configuration, value);
        }
        if (propertyClass.getName().equals(Boolean.class.getName())) {
            boolean value = this.preferences.getBoolean(nameOfPreference, false);
            propertyDescriptor.getWriteMethod().invoke(configuration, value);
        }
        if (propertyClass.getName().equals(Integer.class.getName())) {
            int value = this.preferences.getInt(nameOfPreference, 0);
            propertyDescriptor.getWriteMethod().invoke(configuration, value);
        }
        if (propertyClass.getName().equals(Long.class.getName())) {
            long value = this.preferences.getLong(nameOfPreference, 0L);
            propertyDescriptor.getWriteMethod().invoke(configuration, value);
        }
        if (propertyClass.getName().equals(Double.class.getName())) {
            double value = this.preferences.getDouble(nameOfPreference, 0.0);
            propertyDescriptor.getWriteMethod().invoke(configuration, value);
        }
        if (propertyClass.getName().equals(Float.class.getName())) {
            float value = this.preferences.getFloat(nameOfPreference, 0.0f);
            propertyDescriptor.getWriteMethod().invoke(configuration, Float.valueOf(value));
        }
    }

    private void putProperty(PropertyDescriptor propertyDescriptor, Object configuration, int i) throws IllegalAccessException, InvocationTargetException {
        Object value;
        Class<?> propertyClass = propertyDescriptor.getPropertyType();
        String nameOfPreference = this.profilePrefix + propertyDescriptor.getName() + "_" + i;
        if (propertyClass.getName().equals(String.class.getName())) {
            value = (String)propertyDescriptor.getReadMethod().invoke(configuration, new Object[0]);
            this.preferences.put(nameOfPreference, (String)value);
        }
        if (propertyClass.getName().equals(Boolean.class.getName())) {
            value = (Boolean)propertyDescriptor.getReadMethod().invoke(configuration, new Object[0]);
            this.preferences.putBoolean(nameOfPreference, (Boolean)value);
        }
        if (propertyClass.getName().equals(Integer.class.getName())) {
            value = (Integer)propertyDescriptor.getReadMethod().invoke(configuration, new Object[0]);
            this.preferences.putInt(nameOfPreference, (Integer)value);
        }
        if (propertyClass.getName().equals(Long.class.getName())) {
            value = (Long)propertyDescriptor.getReadMethod().invoke(configuration, new Object[0]);
            this.preferences.putLong(nameOfPreference, (Long)value);
        }
        if (propertyClass.getName().equals(Double.class.getName())) {
            value = (Double)propertyDescriptor.getReadMethod().invoke(configuration, new Object[0]);
            this.preferences.putDouble(nameOfPreference, (Double)value);
        }
        if (propertyClass.getName().equals(Float.class.getName())) {
            value = (Float)propertyDescriptor.getReadMethod().invoke(configuration, new Object[0]);
            this.preferences.putFloat(nameOfPreference, ((Float)value).floatValue());
        }
    }

    private PropertyDescriptor[] getObjectGetSetProperties(Class clazz) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        return bi.getPropertyDescriptors();
    }
}

