/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.profiles;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfo;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfoCollection;
import com.browsersoft.commander.commanderwindow.operation.SimpleWarningAlert;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileCollection;
import com.browsersoft.commander.commanderwindow.profiles.ProfilePanel;
import com.browsersoft.commander.commanderwindow.profiles.ProfilePanelHandler;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.ProfileInfoCollection;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProfilesPanel
extends CenteredDialog
implements ProfilePanelHandler {
    private StorageTypeInfoCollection storageTypes;
    private ProfileCollection profiles;
    private DocumentManager documentManager;
    private JList list;
    private JPanel actualPanel;
    private List<ProfilePanel> profilesPanels = new ArrayList<ProfilePanel>();
    private JButton buttonAdd;
    private JButton buttonCancel;
    private JButton buttonDelete;
    private JButton buttonExport;
    private JButton buttonImport;
    private JButton buttonOK;
    private JToolBar toolbar;

    public ProfilesPanel(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        this.initComponents();
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public StorageTypeInfoCollection getStorageTypes() {
        return this.storageTypes;
    }

    public void setStorageTypes(StorageTypeInfoCollection storageTypes) {
        this.storageTypes = storageTypes;
    }

    public void fillProfiles() throws Exception {
        for (int i = 0; i < this.profiles.size(); ++i) {
            try {
                Profile profile = this.profiles.get(i);
                ProfilePanel profileForm = new ProfilePanel();
                profileForm.setProfilesPanel(this);
                profileForm.setDocumentManager(this.documentManager);
                profileForm.load(profile, this.storageTypes, this);
                profileForm.setName(profile.getProfileName());
                this.profilesPanels.add(profileForm);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateList();
        if (this.profilesPanels.size() > 0) {
            this.selectItem(this.profilesPanels.get(0));
            this.list.setSelectedValue(this.profilesPanels.get(0), true);
        }
    }

    public void updateList() throws Exception {
        this.list.updateUI();
    }

    public void selectItem(Object value) {
        this.actualPanel.removeAll();
        this.actualPanel.add((Component)((ProfilePanel)value), "Center");
        this.actualPanel.updateUI();
    }

    public ProfileInfoCollection getProfilesInfo(boolean saveFirst) throws Exception {
        if (saveFirst) {
            this.saveProfiles();
        }
        return this.profiles.toProfilesInfos();
    }

    public void saveProfiles() throws Exception {
        ArrayList<Profile> profilesList = new ArrayList<Profile>();
        for (ProfilePanel profilePanel : this.profilesPanels) {
            profilesList.add(profilePanel.save());
        }
        this.profiles.setProfiles(profilesList);
    }

    public ProfileCollection getProfiles() {
        return this.profiles;
    }

    public void setProfiles(ProfileCollection profiles) {
        this.profiles = profiles;
    }

    private void initComponents() {
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.toolbar = new JToolBar();
        this.buttonAdd = new JButton();
        this.buttonDelete = new JButton();
        this.buttonExport = new JButton();
        this.buttonImport = new JButton();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.actualPanel = new JPanel();
        this.actualPanel.setLayout(new BorderLayout());
        this.setTitle("Profiles");
        this.setResizable(false);
        this.buttonAdd.setText("Add");
        this.buttonAdd.addActionListener(evt -> this.buttonAddActionPerformed(evt));
        this.toolbar.add(this.buttonAdd);
        this.buttonDelete.setText("Remove");
        this.buttonDelete.addActionListener(evt -> this.buttonDeleteActionPerformed(evt));
        this.toolbar.add(this.buttonDelete);
        this.buttonExport.setText("Export");
        this.buttonExport.addActionListener(evt -> this.buttonExportActionPerformed(evt));
        this.buttonImport.setText("Import");
        this.buttonImport.addActionListener(evt -> this.buttonImportActionPerformed(evt));
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(evt -> this.buttonOKActionPerformed(evt));
        KeyBuffer.installKey(this.getRootPane(), 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilesPanel.this.buttonOK.doClick();
            }
        });
        this.buttonCancel.setText("Back");
        this.buttonCancel.addActionListener(evt -> this.buttonCancelActionPerformed(evt));
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilesPanel.this.buttonCancel.doClick();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jListContainer = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        jListContainer.add((Component)jScrollPane, "Center");
        JPanel upDownButtonPanel = new JPanel(new FlowLayout(2));
        JButton upButton = new JButton("Up");
        upDownButtonPanel.add(upButton);
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = ProfilesPanel.this.profilesPanels.indexOf(ProfilesPanel.this.list.getSelectedValue());
                if (i > 0) {
                    Collections.swap(ProfilesPanel.this.profilesPanels, i, i - 1);
                    ProfilesPanel.this.list.setSelectedValue(ProfilesPanel.this.profilesPanels.get(i - 1), true);
                    try {
                        ProfilesPanel.this.updateList();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JButton downButton = new JButton("Down");
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = ProfilesPanel.this.profilesPanels.indexOf(ProfilesPanel.this.list.getSelectedValue());
                if (i < ProfilesPanel.this.profilesPanels.size() - 1) {
                    Collections.swap(ProfilesPanel.this.profilesPanels, i, i + 1);
                    ProfilesPanel.this.list.setSelectedValue(ProfilesPanel.this.profilesPanels.get(i + 1), true);
                    try {
                        ProfilesPanel.this.updateList();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        upDownButtonPanel.add(downButton);
        jListContainer.add((Component)upDownButtonPanel, "South");
        this.add((Component)this.toolbar, "North");
        this.add((Component)jListContainer, "West");
        this.add((Component)this.actualPanel, "Center");
        this.buttonCancel.setHorizontalAlignment(4);
        this.buttonOK.setHorizontalAlignment(4);
        JPanel okCancelButton = new JPanel();
        okCancelButton.setLayout(new FlowLayout(2));
        okCancelButton.add(this.buttonCancel);
        okCancelButton.add(this.buttonOK);
        this.add((Component)okCancelButton, "South");
        this.setSize(800, 600);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ProfilesPanel.this.selectItem(ProfilesPanel.this.list.getSelectedValue());
                }
            }
        });
        this.list.setModel(new MyListModel(this));
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        try {
            this.saveProfiles();
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
        this.dispose();
    }

    private void buttonImportActionPerformed(ActionEvent evt) {
    }

    private void buttonExportActionPerformed(ActionEvent evt) {
        try {
            JFileChooser newCh = new JFileChooser();
            newCh.showSaveDialog(this);
            File file = newCh.getSelectedFile();
            newCh.setVisible(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        SimpleWarningAlert alert = new SimpleWarningAlert(true);
        alert.setText("<html><div style=\"text-align: center;\">Delete profile '" + this.list.getSelectedValue() + "'?</div></html>");
        alert.setVisible(true);
        if (!alert.isOk()) {
            return;
        }
        this.profilesPanels.remove(this.list.getSelectedValue());
        try {
            this.updateList();
            this.selectItem(this.profilesPanels.get(0));
            this.list.setSelectedValue(this.profilesPanels.get(0), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        try {
            if (this.storageTypes.size() > 0) {
                StorageTypeInfo fistTypeInfo = this.storageTypes.get(0);
                Object defaultConfigurationObject = fistTypeInfo.getStorage().createConfigurationObject();
                Profile defaultProfile = new Profile();
                defaultProfile.setProfileName("New profile");
                defaultProfile.setCommanderPlugStorage(fistTypeInfo.getStorage());
                defaultProfile.setModuleConfiguration(defaultConfigurationObject);
                ProfilePanel profileForm = new ProfilePanel();
                profileForm.setProfilesPanel(this);
                profileForm.setDocumentManager(this.documentManager);
                profileForm.load(defaultProfile, this.storageTypes, this);
                profileForm.setName("New profile");
                this.profilesPanels.add(profileForm);
                this.updateList();
                this.selectItem(profileForm);
                this.list.setSelectedValue(profileForm, true);
            }
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    public List<ProfilePanel> getProfilesPanels() {
        return this.profilesPanels;
    }

    @Override
    public void nameChanged() {
        try {
            this.updateList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyListModel
    implements ListModel {
        ProfilesPanel panel;

        public MyListModel(ProfilesPanel panel) {
            this.panel = panel;
        }

        @Override
        public int getSize() {
            return this.panel.getProfilesPanels().size();
        }

        public String getId(int index) {
            return this.panel.getProfilesPanels().get(index).getUuid();
        }

        public Object getElementAt(int index) {
            return this.panel.getProfilesPanels().get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

