/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.side;

import com.browsersoft.commander.commanderwindow.side.DiscInfo;
import com.browsersoft.commander.commanderwindow.table.JCommanderList;
import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.CommanderPlugStorageModelCollection;
import com.browsersoft.commander.model.CommanderPlugStorageModelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class DiscInfoCollection
extends AbstractListModel<DiscInfo>
implements CommanderPlugStorageModelListener,
ComboBoxModel<DiscInfo> {
    private static final Logger log = Logger.getLogger(DiscInfoCollection.class.getName());
    private final CommanderPlugStorageModelCollection storages;
    private final JCommanderList handler;
    private final LinkedHashMap<String, ArrayList<DiscInfo>> discsByStorage = new LinkedHashMap();
    private final List<DiscInfo> discs = new ArrayList<DiscInfo>();
    private DiscInfo selected;

    public DiscInfoCollection(CommanderPlugStorageModelCollection storages, JCommanderList handler) {
        this.storages = storages;
        this.handler = handler;
        this.updateDiscInfoCollection();
        this.storages.addStorageListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDiscInfoCollection() {
        LinkedHashMap<String, ArrayList<DiscInfo>> originalDisksByStorage;
        Object storage;
        LinkedHashMap<String, Object> storagesMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.storages.size(); ++i) {
            storage = this.storages.get(i);
            String storageId = storage.getProfileName();
            if (storageId == null) {
                storageId = storage.getClass().getCanonicalName();
            }
            storagesMap.put(storageId, storage);
        }
        storage = this;
        synchronized (storage) {
            originalDisksByStorage = new LinkedHashMap<String, ArrayList<DiscInfo>>(this.discsByStorage);
        }
        Iterator<Map.Entry<String, ArrayList<DiscInfo>>> iterator = originalDisksByStorage.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ArrayList<DiscInfo>> entry = iterator.next();
            String storageId = entry.getKey();
            if (!storagesMap.containsKey(storageId)) {
                iterator.remove();
                ArrayList<Integer> removedIndexes = new ArrayList<Integer>();
                DiscInfoCollection discInfoCollection = this;
                synchronized (discInfoCollection) {
                    for (DiscInfo discInfo : this.discsByStorage.get(storageId)) {
                        removedIndexes.add(this.discs.indexOf(discInfo));
                    }
                    for (DiscInfo discInfo : this.discsByStorage.get(storageId)) {
                        this.discs.remove(discInfo);
                    }
                    this.discsByStorage.remove(storageId);
                }
                Collections.sort(removedIndexes);
                int intervalStart = (Integer)removedIndexes.get(0);
                int intervalEnd = (Integer)removedIndexes.get(removedIndexes.size() - 1);
                this.fireIntervalRemoved(this, intervalStart, intervalEnd);
                continue;
            }
            CommanderPlugStorageModel storage2 = (CommanderPlugStorageModel)storagesMap.get(storageId);
            for (DiscInfo discInfo : this.discsByStorage.get(storageId)) {
                boolean changed = this.updateDiscInfo(discInfo, storage2);
                if (!changed) continue;
                int discIndex = this.discs.indexOf(discInfo);
                this.fireContentsChanged(this, discIndex, discIndex);
            }
        }
        int index = 0;
        for (String storageId : storagesMap.keySet()) {
            ArrayList<Integer> addedIndexes = new ArrayList<Integer>();
            DiscInfoCollection discInfoCollection = this;
            synchronized (discInfoCollection) {
                if (this.discsByStorage.containsKey(storageId)) {
                    index += this.discsByStorage.get(storageId).size();
                } else {
                    try {
                        ArrayList<DiscInfo> newDiscs = this.loadStorageDiscs((CommanderPlugStorageModel)storagesMap.get(storageId));
                        this.discsByStorage.put(storageId, newDiscs);
                        for (DiscInfo discInfo : newDiscs) {
                            this.discs.add(index, discInfo);
                            addedIndexes.add(index);
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!addedIndexes.isEmpty()) {
                    int intervalStart = (Integer)addedIndexes.get(0);
                    int intervalEnd = (Integer)addedIndexes.get(addedIndexes.size() - 1);
                    this.fireIntervalAdded(this, intervalStart, intervalEnd);
                }
            }
        }
    }

    private ArrayList<DiscInfo> loadStorageDiscs(CommanderPlugStorageModel storage) throws Exception {
        ArrayList<DiscInfo> discs = new ArrayList<DiscInfo>();
        CommanderPlugModel actualModel = storage.createNewModel();
        actualModel.setHandler(this.handler);
        for (int j = 0; j < storage.getDiscsSize(); ++j) {
            DiscInfo info = new DiscInfo();
            info.setDiscIndex(j);
            if (storage.getProfileName() == null) {
                info.setNameOfDisc(storage.getDiscName(j));
                info.setProfileName("");
            } else {
                info.setNameOfDisc(storage.getProfileName() + "/" + storage.getDiscName(j));
                info.setProfileName(storage.getProfileName());
            }
            info.setDiscId(storage.getDiscId(j));
            info.setModel(actualModel);
            discs.add(info);
        }
        return discs;
    }

    private boolean updateDiscInfo(DiscInfo discInfo, CommanderPlugStorageModel storage) {
        boolean changed = false;
        boolean hasRemoteUpdates = storage.hasRemoteUpdates();
        if (discInfo.hasRemoteUpdates() != hasRemoteUpdates) {
            discInfo.setRemoteUpdates(hasRemoteUpdates);
            changed = true;
        }
        return changed;
    }

    @Override
    public void storagesChanged() {
        this.updateDiscInfoCollection();
    }

    public void unregister() {
        this.storages.removeStorageListener(this);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = (DiscInfo)anItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscInfo getSelectedItem() {
        DiscInfoCollection discInfoCollection = this;
        synchronized (discInfoCollection) {
            if (this.selected != null && this.discs.contains(this.selected)) {
                return this.selected;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        DiscInfoCollection discInfoCollection = this;
        synchronized (discInfoCollection) {
            return this.discs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscInfo getElementAt(int index) {
        DiscInfoCollection discInfoCollection = this;
        synchronized (discInfoCollection) {
            return this.discs.get(index);
        }
    }
}

