/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.table;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.table.JCommanderListColumnIcon;
import com.browsersoft.commander.commanderwindow.table.JCommanderListHandler;
import com.browsersoft.commander.commanderwindow.table.Uuids;
import com.browsersoft.commander.commanderwindow.table.VisualTable;
import com.browsersoft.commander.commanderwindow.table.VisualTableTransferable;
import com.browsersoft.commander.model.CommanderPlugModelHandler;
import com.browsersoft.commander.model.JCommanderListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.UUID;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JCommanderList
extends VisualTable
implements CommanderPlugModelHandler {
    private JCommanderListHandler handler;
    private JCommanderListModel model;
    private int[] lastSelections = new int[]{0};
    private SelectionListener selectionListener = new SelectionListener(this);
    private static String appUuid = UUID.randomUUID().toString();
    private String uuid = UUID.randomUUID().toString();

    public JCommanderList() {
        this.setFont(new Font("Arial Unicode MS", 0, 11));
    }

    public int[] getLastSelections() {
        return this.lastSelections;
    }

    public JCommanderListModel getCommanderSideModel() {
        return this.model;
    }

    public void setCommanderSideModel(JCommanderListModel model) {
        this.model = model;
    }

    public JCommanderListHandler getHandler() {
        return this.handler;
    }

    public void setHandler(JCommanderListHandler handler) {
        this.handler = handler;
    }

    public void generateShowPopup(Component component, Point point) {
        int row = this.rowAtPoint(point);
        this.getSelectionModel().setSelectionInterval(row, row);
        this.handler.showPopup(component, point, row);
    }

    private void generateGoInto() {
        int row = this.getSelectedRow();
        this.getSelectionModel().setSelectionInterval(row, row);
        try {
            this.model.goInto(row);
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("XmlFileChangedException")) {
                ErrorManager.notifyWithCustomMsg(e, null);
            }
            ErrorManager.notify(e);
        }
        this.handler.goInto();
    }

    private void generateFocusGainedEvent() {
        this.handler.focusGained(this);
    }

    public void reinitTable() {
        this.setModel(this.model);
        this.createDefaultColumnsFromModel();
        this.refreshUI();
    }

    public void makeFocusLost() {
    }

    public void makeFocusGain() {
        for (int i = 0; i < this.lastSelections.length; ++i) {
            this.addRowSelectionInterval(this.lastSelections[i], this.lastSelections[i]);
        }
    }

    private void focusLostMethod() {
        this.lastSelections = this.getSelectedRows();
        this.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    public void initTable() {
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.setShowGrid(false);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setDragEnabled(true);
        JTableHeader header = this.getTableHeader();
        header.setUpdateTableInRealTime(true);
        header.addMouseListener(new ColumnListener(this));
        header.setReorderingAllowed(false);
        this.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                try {
                    if (!info.isDrop()) {
                        return false;
                    }
                    if (!info.isDataFlavorSupported(VisualTableTransferable.JTABLE_FLAVOR)) {
                        return false;
                    }
                    Uuids sourceUuids = (Uuids)info.getTransferable().getTransferData(VisualTableTransferable.JTABLE_FLAVOR);
                    if (!sourceUuids.getAppUuid().equals(appUuid)) {
                        return false;
                    }
                    if (sourceUuids.getUuid().equals(JCommanderList.this.uuid)) {
                        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                        return JCommanderList.this.handler.canBeDraggedInTable(dl.getRow());
                    }
                    return JCommanderList.this.handler.canBeDraggedBetweenSides();
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport info) {
                JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                try {
                    Uuids sourceUuids = (Uuids)info.getTransferable().getTransferData(VisualTableTransferable.JTABLE_FLAVOR);
                    if (sourceUuids.getUuid().equals(JCommanderList.this.uuid)) {
                        JCommanderList.this.handler.dragInTable(dl.getRow());
                    } else {
                        JCommanderList.this.handler.dragBetweenSides(dl.getRow());
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public void exportDone(JComponent c, Transferable t, int action) {
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new VisualTableTransferable(new Uuids(appUuid, JCommanderList.this.uuid));
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JCommanderList.this.getSelectedRows().length == 0) {
                    for (int i = 0; i < JCommanderList.this.lastSelections.length; ++i) {
                        if (JCommanderList.this.lastSelections[i] >= JCommanderList.this.getRowCount()) continue;
                        JCommanderList.this.addRowSelectionInterval(JCommanderList.this.lastSelections[i], JCommanderList.this.lastSelections[i]);
                    }
                }
                JCommanderList.this.generateFocusGainedEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JCommanderList.this.focusLostMethod();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                int pressedKey = evt.getKeyCode();
                switch (pressedKey) {
                    case 10: {
                        JCommanderList.this.generateGoInto();
                        evt.consume();
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        break;
                    }
                    default: {
                        if (evt.isAltDown() || evt.isControlDown() || evt.isMetaDown()) break;
                        JCommanderList.this.handler.keyPressed(evt);
                        evt.consume();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int rowAtPoint;
                if (evt.getClickCount() == 2 && (rowAtPoint = JCommanderList.this.rowAtPoint(evt.getPoint())) != -1) {
                    JCommanderList.this.generateGoInto();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCommanderList.this.generateShowPopup(e.getComponent(), e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JCommanderList.this.generateShowPopup(e.getComponent(), e.getPoint());
                }
            }
        });
    }

    public void reinit() {
        this.setModel(this.model);
        this.createDefaultColumnsFromModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            int sizeInPixels = this.model.getInitColumnSize(i);
            this.setColumnSize(i, sizeInPixels);
        }
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            JCommanderListColumnIcon icon = new JCommanderListColumnIcon(Color.BLACK, 0);
            Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
            JLabel columnComponent = new JLabel(this.model.getColumnName(i), icon, 0);
            columnComponent.setFont(new Font("Arial", 0, 11));
            columnComponent.setHorizontalAlignment(2);
            columnComponent.setBorder(headerBorder);
            column.setHeaderValue(columnComponent);
            column.setHeaderRenderer(new JComponentTableCellRenderer());
        }
    }

    private void setColumnSize(int index, int size) {
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setPreferredWidth(size);
    }

    @Override
    public void setSelectionInterval(int i, int i0) {
        this.setRowSelectionInterval(i, i0);
        this.scrollRectToVisible(this.getCellRect(i, 0, true));
    }

    @Override
    public void openInOpositeWindow(String path) throws Exception {
        this.handler.openInOpositeWindow(path);
    }

    @Override
    public void openInOpositeWindow(List<String> path) throws Exception {
        this.handler.openInOppositeWindow(path);
    }

    @Override
    public void openPath(List<String> path, boolean oposite) throws Exception {
        this.handler.openPath(path, oposite);
    }

    @Override
    public void reconnect() throws Exception {
        this.handler.reconnect();
    }

    @Override
    public void refreshUI() {
        this.reinit();
        this.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JCommanderList.this.handler.columnResized();
                JCommanderList.this.getTableHeader().repaint();
            }
        });
    }

    class JComponentTableCellRenderer
    implements TableCellRenderer {
        JComponentTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        JCommanderList table;

        SelectionListener(JCommanderList table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                this.table.getHandler().selectionChanged();
            }
        }
    }

    class ColumnListener
    extends MouseAdapter {
        private JCommanderList table;

        public ColumnListener(JCommanderList table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumnModel colModel = this.table.getColumnModel();
            int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
            for (int i = 0; i < colModel.getColumnCount(); ++i) {
                TableColumn column = colModel.getColumn(i);
                JCommanderListColumnIcon icon = (JCommanderListColumnIcon)((JLabel)column.getHeaderValue()).getIcon();
                if (i == columnModelIndex) {
                    if (icon.getType() == 1) {
                        icon.setType(2);
                        try {
                            this.table.getCommanderSideModel().sortColumn(i, true);
                        }
                        catch (Exception ex) {
                            ErrorManager.notify(ex);
                        }
                    } else {
                        icon.setType(1);
                        try {
                            this.table.getCommanderSideModel().sortColumn(i, false);
                        }
                        catch (Exception ex) {
                            ErrorManager.notify(ex);
                        }
                    }
                    JCommanderList.this.updateUI();
                    continue;
                }
                icon.setType(0);
            }
            this.table.getTableHeader().repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            JCommanderList.this.handler.columnResized();
        }
    }
}

