/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.SaveHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class DiffNode {
    private final boolean readableOnly;
    private final String nameLabel;
    private String text;
    private final List<String> lines = new ArrayList<String>();
    private List<Integer> cumulativeLineLength;
    private SaveHandler saveHandler;

    public DiffNode(byte[] dataToCompare, boolean readableOnly) {
        this.readableOnly = readableOnly;
        this.nameLabel = "";
        this.updateLines(new String(dataToCompare, Charset.forName("utf-8")));
    }

    public DiffNode(File file, boolean readableOnly) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File in diff node must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("File to compare must exist(" + file.exists() + ") " + "and must not be directory(" + !file.isDirectory() + ")!");
        }
        this.readableOnly = readableOnly;
        this.nameLabel = file.getName();
        this.readFile(file);
    }

    private void readFile(File file) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        this.lines.clear();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int character;
            while ((character = bis.read()) != -1) {
                sb.append((char)character);
            }
        }
        this.updateLines(sb.toString());
    }

    void updateLines(String text) {
        this.text = text;
        this.lines.clear();
        StringBuilder lineBuffer = new StringBuilder(128);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                lineBuffer.append('\n');
                this.lines.add(lineBuffer.toString());
                lineBuffer = new StringBuilder(128);
                continue;
            }
            if (i < text.length() - 1 && c == '\r' && text.charAt(i + 1) == '\n') {
                lineBuffer.append("\r\n");
                ++i;
                this.lines.add(lineBuffer.toString());
                lineBuffer = new StringBuilder(128);
                continue;
            }
            if (i == text.length() - 1) {
                lineBuffer.append(c);
                this.lines.add(lineBuffer.toString());
                continue;
            }
            lineBuffer.append(c);
        }
        this.countLinesLength();
    }

    private void countLinesLength() {
        this.cumulativeLineLength = new ArrayList<Integer>(this.lines.size());
        int lineOffset = 0;
        for (String line : this.lines) {
            this.cumulativeLineLength.add(lineOffset += line.length());
        }
    }

    public String getText() {
        return this.text;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public int getLineEndOffsetPosition(int lineNumber) {
        if (lineNumber < 0 || lineNumber > this.cumulativeLineLength.size()) {
            throw new IllegalArgumentException("Line number(" + lineNumber + ") is out of bounds in your text");
        }
        return lineNumber == 0 ? 0 : this.cumulativeLineLength.get(lineNumber - 1);
    }

    public String getNameLabel() {
        return this.nameLabel;
    }

    public void registerSaveHandler(SaveHandler handler) {
        this.saveHandler = handler;
    }

    public void writeFile(String text) {
        if (!this.readableOnly && this.saveHandler != null) {
            this.saveHandler.save(text);
        }
    }

    public boolean isReadableOnly() {
        return this.readableOnly;
    }
}

