/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.DiffEditor;
import com.browsersoft.commander.customEditor.FilePanel;
import com.browsersoft.commander.customEditor.VerticalSyncScroller;
import com.browsersoft.commander.customEditor.java_diff_utils.Chunk;
import com.browsersoft.commander.customEditor.java_diff_utils.Delta;
import com.browsersoft.commander.customEditor.utils.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class RevisionBar
extends JComponent {
    private final DiffEditor.Diff diffs;
    private final FilePanel filePanel;
    private final VerticalSyncScroller scroller;

    public RevisionBar(DiffEditor.Diff diffs, FilePanel filePanel, VerticalSyncScroller scroller) {
        if (filePanel == null) {
            throw new IllegalArgumentException("FilePanel must not be null");
        }
        if (scroller == null) {
            throw new IllegalArgumentException("VerticalSyncScroller must not be null");
        }
        this.diffs = diffs;
        this.filePanel = filePanel;
        this.scroller = scroller;
        this.setBorder(BorderFactory.createLineBorder(Colors.REVISION_BAR_BORDER));
        this.addMouseListener(this.getMouseListener());
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.diffs.isReady()) {
            return;
        }
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds == null) {
            System.out.println("ClipBounds for painting the RevisionBar is null");
            return;
        }
        Rectangle drawableArea = this.getScrollBarDrawableRectangle();
        if (drawableArea.height == 0) {
            return;
        }
        drawableArea.x = clipBounds.x;
        drawableArea.width = clipBounds.width;
        g.setColor(Color.white);
        g.fillRect(drawableArea.x, drawableArea.y, drawableArea.width, drawableArea.height);
        int numberOfLines = this.getNumberOfLines();
        if (numberOfLines == 0) {
            return;
        }
        for (Delta delta : this.diffs.getDeltas()) {
            g.setColor(Colors.getColor(delta.getType()));
            Chunk chunk = this.filePanel.isLeftOriented() ? delta.getOriginal() : delta.getRevised();
            int y = drawableArea.y + drawableArea.height * chunk.getPosition() / numberOfLines;
            if (y < 3) {
                y = Math.min(drawableArea.y + 3, drawableArea.height);
            } else if (y > drawableArea.height - 3) {
                y = Math.max(drawableArea.height - 3, drawableArea.y);
            }
            int height = drawableArea.height * chunk.size() / numberOfLines;
            if (height <= 0) {
                height = 1;
            }
            g.fillRect(0, y, drawableArea.width, height);
        }
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int numberOfLines;
                if (!RevisionBar.this.diffs.isReady()) {
                    return;
                }
                Rectangle drawableArea = RevisionBar.this.getScrollBarDrawableRectangle();
                if (drawableArea.height <= 0) {
                    return;
                }
                int y = event.getY() - drawableArea.y;
                int line = y * (numberOfLines = RevisionBar.this.getNumberOfLines()) / drawableArea.height;
                if (line > numberOfLines) {
                    line = numberOfLines;
                }
                if (line < 0) {
                    line = 0;
                }
                int lineBefore = (y - 10) * numberOfLines / drawableArea.height;
                int lineAfter = (y + 10) * numberOfLines / drawableArea.height;
                for (Delta delta : RevisionBar.this.diffs.getDeltas()) {
                    Chunk chunk = RevisionBar.this.filePanel.isLeftOriented() ? delta.getOriginal() : delta.getRevised();
                    if (chunk.getPosition() <= lineBefore || chunk.getPosition() >= lineAfter) continue;
                    RevisionBar.this.scroller.scrollToDelta(RevisionBar.this.filePanel, delta);
                    return;
                }
                RevisionBar.this.scroller.scrollToLineMoreVisible(RevisionBar.this.filePanel, line);
            }
        };
    }

    private Rectangle getScrollBarDrawableRectangle() {
        JScrollBar verticalScrollBar = this.filePanel.getScrollPane().getVerticalScrollBar();
        if (!verticalScrollBar.isVisible()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = verticalScrollBar.getBounds();
        r.x = 0;
        r.y = 0;
        for (Component c : verticalScrollBar.getComponents()) {
            if (!(c instanceof AbstractButton)) continue;
            r.y += c.getHeight();
            r.height -= 2 * c.getHeight();
            break;
        }
        return r;
    }

    private int getNumberOfLines() {
        return this.filePanel.getDiffNode().getLines().size();
    }
}

