/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.DiffEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SavePanelDialog {
    private final DiffEditor parent;
    private final JOptionPane optionPane;
    private JCheckBox[] checkBoxes;

    public SavePanelDialog(DiffEditor diffEditor) {
        this.parent = diffEditor;
        this.optionPane = new JOptionPane(this.getSavePanel(), 2);
        this.optionPane.setOptionType(2);
    }

    public void show() {
        JDialog dialog = this.optionPane.createDialog(this.parent, "Save files");
        dialog.setResizable(true);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
    }

    private JComponent getSavePanel() {
        JPanel panel = new JPanel((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec("fill:10px:noGrow"), new ColumnSpec("fill:pref:noGrow"), new ColumnSpec("fill:10px:noGrow")}, new RowSpec[]{new RowSpec("center:10px:noGrow"), new RowSpec("fill:pref:noGrow"), new RowSpec("center:5px:noGrow"), new RowSpec("fill:pref:noGrow"), new RowSpec("center:10px:noGrow"), new RowSpec("fill:pref:noGrow"), new RowSpec("fill:pref:noGrow"), new RowSpec("center:10px:noGrow")}));
        CellConstraints cc = new CellConstraints();
        JLabel label = new JLabel("Some files have been changed");
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
        label.setHorizontalAlignment(2);
        panel.add((Component)label, cc.xy(2, 2));
        label = new JLabel("Which ones would you like to save?");
        label.setFont(font);
        label.setHorizontalAlignment(2);
        panel.add((Component)label, cc.xy(2, 4));
        String leftNameLabel = this.parent.getLeftFilePanel().getDiffNode().getNameLabel();
        String rightNameLabel = this.parent.getRightFilePanel().getDiffNode().getNameLabel();
        this.checkBoxes = new JCheckBox[]{new JCheckBox(leftNameLabel == null || leftNameLabel.isEmpty() ? "left data" : leftNameLabel, !this.parent.getLeftFilePanel().isSaved()), new JCheckBox(rightNameLabel == null || rightNameLabel.isEmpty() ? "right data" : rightNameLabel, !this.parent.getRightFilePanel().isSaved())};
        this.checkBoxes[0].setEnabled(!this.parent.getLeftFilePanel().isSaved());
        this.checkBoxes[1].setEnabled(!this.parent.getRightFilePanel().isSaved());
        panel.add((Component)this.checkBoxes[0], cc.xy(2, 6));
        panel.add((Component)this.checkBoxes[1], cc.xy(2, 7));
        return panel;
    }

    public boolean doSave() {
        if (!Integer.valueOf(0).equals(this.optionPane.getValue())) {
            return false;
        }
        if (this.checkBoxes[0].isSelected()) {
            this.parent.getLeftFilePanel().saveFile();
        }
        if (this.checkBoxes[1].isSelected()) {
            this.parent.getRightFilePanel().saveFile();
        }
        return true;
    }
}

