/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor.java_diff_utils;

import com.browsersoft.commander.customEditor.java_diff_utils.Chunk;
import com.browsersoft.commander.customEditor.java_diff_utils.Delta;
import com.browsersoft.commander.customEditor.java_diff_utils.PatchFailedException;
import java.util.List;

public class DeleteDelta
extends Delta {
    public DeleteDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    @Override
    public void restore(List<Object> target) {
        int position = this.getRevised().getPosition();
        List<?> lines = this.getOriginal().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.DELETE;
    }

    @Override
    public void verify(List<?> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + "]";
    }
}

