/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor.utils;

import com.browsersoft.commander.customEditor.java_diff_utils.Delta;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;

public final class Colors {
    public static final Color ADDED_COLOR = new Color(101, 255, 157);
    public static final Color CHANGED_COLOR = new Color(160, 200, 255);
    public static final Color CHANGED_LIGHTER_COLOR = new Color(212, 230, 255);
    public static final Color DELETED_COLOR = new Color(255, 160, 180);
    public static final Color REVISION_BAR_BORDER = new Color(212, 212, 212);
    private static final DefaultHighlighter.DefaultHighlightPainter addPainter = new DefaultHighlighter.DefaultHighlightPainter(ADDED_COLOR);
    private static final DefaultHighlighter.DefaultHighlightPainter changePainter = new DefaultHighlighter.DefaultHighlightPainter(CHANGED_COLOR);
    public static final DefaultHighlighter.DefaultHighlightPainter changeLighterPainter = new DefaultHighlighter.DefaultHighlightPainter(CHANGED_LIGHTER_COLOR);
    private static final DefaultHighlighter.DefaultHighlightPainter deletePainter = new DefaultHighlighter.DefaultHighlightPainter(DELETED_COLOR);
    private static final DefaultHighlighter.DefaultHighlightPainter deleteEmptyLinePainter = new LinePainter(DELETED_COLOR);
    private static final DefaultHighlighter.DefaultHighlightPainter addEmptyLinePainter = new LinePainter(ADDED_COLOR);

    private Colors() {
    }

    public static Color getColor(Delta.TYPE type) {
        Color color;
        switch (type) {
            case DELETE: {
                color = DELETED_COLOR;
                break;
            }
            case CHANGE: {
                color = CHANGED_COLOR;
                break;
            }
            case INSERT: {
                color = ADDED_COLOR;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown delta type: " + (Object)((Object)type));
            }
        }
        return color;
    }

    public static DefaultHighlighter.DefaultHighlightPainter getPainter(Delta.TYPE type, boolean isEmptyLine) {
        DefaultHighlighter.DefaultHighlightPainter painter;
        switch (type) {
            case DELETE: {
                painter = isEmptyLine ? deleteEmptyLinePainter : deletePainter;
                break;
            }
            case CHANGE: {
                painter = changePainter;
                break;
            }
            case INSERT: {
                painter = isEmptyLine ? addEmptyLinePainter : addPainter;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown delta type: " + (Object)((Object)type));
            }
        }
        return painter;
    }

    private static class LinePainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private LinePainter(Color color) {
            super(color);
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape shape, JTextComponent comp) {
            Rectangle b = shape.getBounds();
            try {
                Rectangle r1 = comp.modelToView(p0);
                g.setColor(this.getColor());
                int yLine = r1.y;
                g.drawLine(0, yLine, b.x + b.width, yLine);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }
}

