/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.form.dialogs;

import com.browsersoft.commander.form.fields.Field;
import com.browsersoft.commander.form.validators.FieldValidator;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public abstract class SimpleDialog<T, C extends JComponent>
extends CenteredDialog {
    private JLabel fieldLabel;
    private JLabel errorField;
    private JButton buttonCancel;
    private JButton buttonOK;
    private final Field<T, C> valueField = this.createValueField();
    private T value;

    public SimpleDialog(Frame parent, String title, String label) {
        super(parent, true);
        this.initComponents();
        this.centerParent();
        this.setTitle(title);
        this.fieldLabel.setText(label);
    }

    protected abstract Field<T, C> createValueField();

    protected Field<T, C> getValueField() {
        return this.valueField;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.valueField.setValue(value);
        this.value = value;
    }

    protected void setError(String error) {
        if (error == null || error.isEmpty()) {
            return;
        }
        this.errorField.setText(error);
        this.errorField.setVisible(true);
        this.revalidate();
        this.pack();
    }

    public void addValidator(FieldValidator validator) {
        this.valueField.addValidator(validator);
    }

    protected void doOK() {
        this.valueField.validate();
        if (!this.valueField.isValid()) {
            this.setError(this.valueField.getError());
            return;
        }
        this.value = this.valueField.getValue();
        this.dispose();
    }

    protected void doCancel() {
        this.dispose();
    }

    private void initComponents() {
        this.fieldLabel = new JLabel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.errorField = new JLabel();
        this.errorField.setForeground(Color.RED);
        this.errorField.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.setTitle("Simple dialog title");
        this.setResizable(false);
        this.fieldLabel.setText("Simple dialog header");
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(evt -> this.doOK());
        this.buttonOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleDialog.this.buttonOKKeyPressed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(evt -> this.doCancel());
        this.buttonCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleDialog.this.buttonCancelKeyPressed(evt);
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDialog.this.doCancel();
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDialog.this.doOK();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.buttonOK, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent((Component)this.valueField.getComponent(), -2, 350, -2).addComponent(this.errorField, -2, 350, -2))).addContainerGap(23, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fieldLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.valueField.getComponent(), -2, -1, -2).addGap(5).addComponent(this.errorField, -2, -1, -2).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonCancelKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doCancel();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    private void buttonOKKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doOK();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }
}

