/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model;

import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileCollection;
import com.browsersoft.commander.commanderwindow.profiles.ProfileListener;
import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.CommanderPlugStorageModelChecker;
import com.browsersoft.commander.model.CommanderPlugStorageModelListener;
import java.util.ArrayList;
import java.util.List;

public class CommanderPlugStorageModelCollection
implements ProfileListener {
    private final ProfileCollection profiles;
    private final List<CommanderPlugStorageModel> staticModels = new ArrayList<CommanderPlugStorageModel>();
    private final List<CommanderPlugStorageModel> models = new ArrayList<CommanderPlugStorageModel>();
    private final List<CommanderPlugStorageModelListener> listeners = new ArrayList<CommanderPlugStorageModelListener>();
    private CommanderPlugStorageModelChecker checker;

    public CommanderPlugStorageModelCollection(ProfileCollection profiles, List<CommanderPlugStorageModel> staticModels, int interval) {
        this.profiles = profiles;
        this.staticModels.addAll(staticModels);
        this.profiles.addProfileListener(this);
        if (interval > 0) {
            this.checker = new CommanderPlugStorageModelChecker(this, interval);
            this.checker.setDaemon(true);
            this.checker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommanderPlugStorageModel get(int index) {
        if (index >= this.staticModels.size()) {
            List<CommanderPlugStorageModel> list = this.models;
            synchronized (list) {
                return this.models.get(index - this.staticModels.size());
            }
        }
        return this.staticModels.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<CommanderPlugStorageModel> list = this.models;
        synchronized (list) {
            return this.staticModels.size() + this.models.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilesChanged() throws Exception {
        List<CommanderPlugStorageModel> list = this.models;
        synchronized (list) {
            this.models.clear();
            for (int i = 0; i < this.profiles.size(); ++i) {
                Profile profile = this.profiles.get(i);
                if (!profile.isConnected()) continue;
                CommanderPlugStorageModel model = profile.getCommanderPlugStorageModel();
                model.setProfileName(profile.getProfileName());
                this.models.add(model);
            }
        }
        this.fireStoragesChanged();
    }

    public void fireStoragesChanged() {
        for (CommanderPlugStorageModelListener listener : this.listeners) {
            listener.storagesChanged();
        }
    }

    public void unregister() {
        this.profiles.removeProfileListener(this);
    }

    public void addStorageListener(CommanderPlugStorageModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeStorageListener(CommanderPlugStorageModelListener listener) {
        this.listeners.remove(listener);
    }

    public void clearStorageListeners() {
        this.listeners.clear();
    }
}

