/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.Flavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.FlavouredItemCollection;
import com.browsersoft.commander.model.NamedItem;
import com.browsersoft.commander.model.OperationWorkerHandler;
import com.browsersoft.commander.model.adapter.AdapterAction;
import com.browsersoft.commander.model.adapter.AdapterActionCollection;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.CompareAction;
import com.browsersoft.commander.model.adapter.CreateLinkAdapterItem;
import com.browsersoft.commander.model.adapter.CustomKeyListener;
import com.browsersoft.commander.model.adapter.DeleteAdapterAction;
import com.browsersoft.commander.model.adapter.ExportAdapterAction;
import com.browsersoft.commander.model.adapter.ImportAdapterAction;
import com.browsersoft.commander.model.adapter.MoveAdapterAction;
import com.browsersoft.commander.model.adapter.NewAdapterAction;
import com.browsersoft.commander.model.adapter.ReorderAdapterAction;
import com.browsersoft.commander.model.adapter.RunAdapterAction;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class ActionResolver {
    private AdapterActionCollection defaultExportCopyActions;
    private AdapterActionCollection defaultImportCopyActions;
    private AdapterActionCollection deleteActions;
    private AdapterActionCollection moveActions;
    private AdapterActionCollection linkActions;
    private AdapterActionCollection otherActions;
    private AdapterItemCollection items;
    private AdapterPath path;

    public ActionResolver(AdapterActionCollection actions, AdapterItemCollection items, AdapterPath path) {
        this.items = items;
        this.path = path;
        this.defaultExportCopyActions = new AdapterActionCollection();
        this.defaultImportCopyActions = new AdapterActionCollection();
        this.deleteActions = new AdapterActionCollection();
        this.moveActions = new AdapterActionCollection();
        this.linkActions = new AdapterActionCollection();
        this.otherActions = new AdapterActionCollection();
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                AdapterAction action = actions.get(i);
                if (action instanceof NewAdapterAction) {
                    this.otherActions.add(action);
                    continue;
                }
                if (action instanceof ReorderAdapterAction) {
                    this.otherActions.add(action);
                    continue;
                }
                if (action instanceof RunAdapterAction) {
                    this.otherActions.add(action);
                    continue;
                }
                if (action instanceof CompareAction) {
                    this.otherActions.add(action);
                    continue;
                }
                if (action instanceof DeleteAdapterAction) {
                    this.deleteActions.add(action);
                    continue;
                }
                if (action instanceof MoveAdapterAction) {
                    this.moveActions.add(action);
                    continue;
                }
                if (action instanceof CreateLinkAdapterItem) {
                    this.linkActions.add(action);
                    continue;
                }
                if (action instanceof ImportAdapterAction) {
                    if (((ImportAdapterAction)action).isDefaultForCopy()) {
                        this.defaultImportCopyActions.add(action);
                        continue;
                    }
                    this.otherActions.add(action);
                    continue;
                }
                if (!(action instanceof ExportAdapterAction)) continue;
                if (((ExportAdapterAction)action).isDefaultForCopy()) {
                    this.defaultExportCopyActions.add(action);
                    continue;
                }
                this.otherActions.add(action);
            }
        }
    }

    public FlavouredItemCollection getFlavouredItemsForCopy(int[] items, int action) throws Exception {
        AdapterItemCollection selectedItems = this.getSelectedItems(items);
        if (selectedItems.size() == 0) {
            return null;
        }
        if (action == -1) {
            for (int i = 0; i < this.defaultExportCopyActions.size(); ++i) {
                ExportAdapterAction exportAction = (ExportAdapterAction)this.defaultExportCopyActions.get(i);
                if (!exportAction.checkItems(selectedItems, this.path)) continue;
                return exportAction.exportItems(selectedItems, this.path);
            }
            return null;
        }
        ExportAdapterAction exportAction = (ExportAdapterAction)this.otherActions.get(action);
        if (exportAction.checkItems(selectedItems, this.path)) {
            return exportAction.exportItems(selectedItems, this.path);
        }
        return null;
    }

    public boolean checkItemForCopy(FlavouredItem item, int action) throws Exception {
        if (action == -1) {
            for (int i = 0; i < this.defaultImportCopyActions.size(); ++i) {
                ImportAdapterAction importAction = (ImportAdapterAction)this.defaultImportCopyActions.get(i);
                if (!importAction.checkItem(item, this.path)) continue;
                return true;
            }
        } else {
            ImportAdapterAction importAction = (ImportAdapterAction)this.otherActions.get(action);
            return importAction.checkItem(item, this.path);
        }
        return false;
    }

    public void compare(Flavour flavour1, Flavour flavour2, int action) throws Exception {
        CompareAction compareAction = (CompareAction)this.otherActions.get(action);
        compareAction.compareItem(flavour1, flavour2);
    }

    public void copyItem(FlavouredItem item, OperationWorkerHandler handler, int action) throws Exception {
        if (action == -1) {
            for (int i = 0; i < this.defaultImportCopyActions.size(); ++i) {
                ImportAdapterAction importAction = (ImportAdapterAction)this.defaultImportCopyActions.get(i);
                if (!importAction.checkItem(item, this.path)) continue;
                importAction.importItem(item, this.path, handler);
            }
        } else {
            ImportAdapterAction importAction = (ImportAdapterAction)this.otherActions.get(action);
            if (importAction.checkItem(item, this.path)) {
                importAction.importItem(item, this.path, handler);
            }
        }
    }

    public boolean existItem(FlavouredItem item, int action) throws Exception {
        if (action == -1) {
            for (int i = 0; i < this.defaultImportCopyActions.size(); ++i) {
                ImportAdapterAction importAction = (ImportAdapterAction)this.defaultImportCopyActions.get(i);
                if (!importAction.checkItem(item, this.path)) continue;
                return importAction.existItem(item, this.path);
            }
        } else {
            ImportAdapterAction importAction = (ImportAdapterAction)this.otherActions.get(action);
            return importAction.existItem(item, this.path);
        }
        return false;
    }

    public NamedItem getItemForMove(int index) throws Exception {
        return this.getItem(index);
    }

    public void moveItem(NamedItem item, OperationWorkerHandler handler) throws Exception {
        for (int i = 0; i < this.moveActions.size(); ++i) {
            MoveAdapterAction moveAdapterAction = (MoveAdapterAction)this.moveActions.get(i);
            if (!moveAdapterAction.checkItem(item, this.path)) continue;
            moveAdapterAction.moveItem(item, this.path, handler);
        }
    }

    public void linkItem(NamedItem item, OperationWorkerHandler handler) throws Exception {
        for (int i = 0; i < this.linkActions.size(); ++i) {
            CreateLinkAdapterItem linkAdapterAction = (CreateLinkAdapterItem)this.linkActions.get(i);
            if (!linkAdapterAction.checkItem(item, this.path)) continue;
            linkAdapterAction.linkItem(item, this.path, handler);
        }
    }

    public boolean checkMove(NamedItem item) throws Exception {
        for (int i = 0; i < this.moveActions.size(); ++i) {
            MoveAdapterAction moveAdapterAction = (MoveAdapterAction)this.moveActions.get(i);
            if (!moveAdapterAction.checkItem(item, this.path)) continue;
            return true;
        }
        return false;
    }

    public boolean checkLink(NamedItem item) throws Exception {
        for (int i = 0; i < this.linkActions.size(); ++i) {
            CreateLinkAdapterItem linkAdapterAction = (CreateLinkAdapterItem)this.linkActions.get(i);
            if (!linkAdapterAction.checkItem(item, this.path)) continue;
            return true;
        }
        return false;
    }

    public NamedItem getItemForDelete(int index) throws Exception {
        AdapterItem item = this.getItem(index);
        if (item == null) {
            return null;
        }
        for (int i = 0; i < this.deleteActions.size(); ++i) {
            DeleteAdapterAction deleteAction = (DeleteAdapterAction)this.deleteActions.get(i);
            if (!deleteAction.checkItem(item)) continue;
            return item;
        }
        return null;
    }

    public void deleteItem(NamedItem item, OperationWorkerHandler handler) throws Exception {
        AdapterItem adapterItem = (AdapterItem)item;
        if (item == null) {
            return;
        }
        for (int i = 0; i < this.deleteActions.size(); ++i) {
            DeleteAdapterAction deleteAction = (DeleteAdapterAction)this.deleteActions.get(i);
            if (!deleteAction.checkItem(adapterItem)) continue;
            deleteAction.deleteItem(adapterItem);
        }
    }

    public int getNumberOfActions() {
        return this.otherActions.size();
    }

    public AdapterAction getAction(int index) {
        return this.otherActions.get(index);
    }

    public String getActionName(int index) {
        return this.otherActions.get(index).getName();
    }

    public Icon getActionIcon(int index) {
        return this.otherActions.get(index).getIcon();
    }

    public String getActionDescription(int index) {
        return this.otherActions.get(index).getDescription();
    }

    public int getActionKey(int index) {
        AdapterAction action = this.otherActions.get(index);
        if (action instanceof CustomKeyListener) {
            return ((CustomKeyListener)((Object)action)).getCustomKeyCode();
        }
        return -1;
    }

    public int getActionType(int index) {
        AdapterAction action = this.otherActions.get(index);
        if (action instanceof NewAdapterAction) {
            return 0;
        }
        if (action instanceof ImportAdapterAction) {
            return 1;
        }
        if (action instanceof ExportAdapterAction) {
            return 2;
        }
        if (action instanceof RunAdapterAction) {
            return 3;
        }
        if (action instanceof ReorderAdapterAction) {
            return 4;
        }
        if (action instanceof MoveAdapterAction) {
            return 5;
        }
        if (action instanceof CreateLinkAdapterItem) {
            return 6;
        }
        if (action instanceof CompareAction) {
            return 7;
        }
        return -1;
    }

    public Map<String, String> getActionVariations(int index) {
        AdapterAction adapterAction = this.otherActions.get(index);
        if (adapterAction instanceof RunAdapterAction) {
            return ((RunAdapterAction)adapterAction).getVariations();
        }
        return new HashMap<String, String>();
    }

    public boolean showDisabledDelete(int index) {
        AdapterItem item = this.getItem(index);
        for (int i = 0; i < this.deleteActions.size(); ++i) {
            DeleteAdapterAction deleteAction = (DeleteAdapterAction)this.deleteActions.get(i);
            if (!deleteAction.showDisabledDelete(item)) continue;
            return true;
        }
        return false;
    }

    public boolean checkNew(int index) throws Exception {
        NewAdapterAction action = (NewAdapterAction)this.otherActions.get(index);
        return action.checkItem(this.path.getLast());
    }

    private boolean isContinueous(int[] items) {
        for (int i = 1; i < items.length; ++i) {
            if (items[i - 1] + 1 == items[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isMovingBlock(int[] items, int after) {
        int first = items[0];
        int last = items[items.length - 1];
        return after < first - 1 || after > last;
    }

    public boolean checkReorder(int actionIndex, int[] items, int after) throws Exception {
        if (!this.isContinueous(items)) {
            return false;
        }
        if (!this.isMovingBlock(items, --after)) {
            return false;
        }
        AdapterItemCollection itemCollection = this.getSelectedItems(items);
        ReorderAdapterAction action = (ReorderAdapterAction)this.otherActions.get(actionIndex);
        AdapterItem adapterItem = this.getItem(after);
        if (adapterItem == null && this.path.size() > 1 && after == -1) {
            return false;
        }
        return action.checkItem(itemCollection, adapterItem);
    }

    public void reorder(int actionIndex, int[] items, int after) throws Exception {
        AdapterItem adapterItem;
        AdapterItemCollection itemCollection = this.getSelectedItems(items);
        ReorderAdapterAction action = (ReorderAdapterAction)this.otherActions.get(actionIndex);
        if ((adapterItem = this.getItem(--after)) == null && this.path.size() > 1 && after == -1) {
            return;
        }
        action.reorder(itemCollection, this.getItem(after));
    }

    public void doNew(Frame parent, int index) throws Exception {
        NewAdapterAction action = (NewAdapterAction)this.otherActions.get(index);
        action.doNew(parent, this.path);
    }

    public boolean checkRun(int index) throws Exception {
        RunAdapterAction action = (RunAdapterAction)this.otherActions.get(index);
        return action.checkItem(this.path.getLast());
    }

    public void doRun(Frame parent, int index, String variation) throws Exception {
        RunAdapterAction action = (RunAdapterAction)this.otherActions.get(index);
        action.run(parent, this.path, variation);
    }

    public AdapterItem getItem(int index) {
        if (this.path.size() > 1 ? --index >= 0 && index < this.items.size() : index >= 0 && index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    private AdapterItemCollection getSelectedItems(int[] indexes) {
        AdapterItemCollection newItems = new AdapterItemCollection();
        if (this.path.size() > 1) {
            for (int i : indexes) {
                if (--i < 0 || i >= this.items.size()) continue;
                newItems.add(this.items.get(i));
            }
        } else {
            for (int i : indexes) {
                if (i < 0 || i >= this.items.size()) continue;
                newItems.add(this.items.get(i));
            }
        }
        return newItems;
    }

    public NamedItem getItemForLink(int index) {
        return this.getItem(index);
    }
}

