/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.adapter.AdapterAction;
import com.browsersoft.commander.model.adapter.AdapterActionCollection;
import com.browsersoft.commander.model.adapter.AdapterItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AdapterItemCollection {
    private ArrayList<AdapterItem> objects;
    private int initIndex = 0;
    private AdapterActionCollection actions = new AdapterActionCollection();
    private Comparator comparatorForName = null;
    private boolean noSearch;
    private String contextLabel = "";
    private Exception contextLabelError = null;
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1.getClass().equals(o2.getClass())) {
                return 0;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    };

    public AdapterItemCollection() {
        this.objects = new ArrayList();
    }

    public void add(AdapterItem item) {
        this.objects.add(item);
    }

    public void addCollection(AdapterItemCollection collection) {
        for (AdapterItem adapterItem : collection.getObjects()) {
            this.add(adapterItem);
        }
        for (int i = 0; i < collection.getActions().size(); ++i) {
            this.actions.add(collection.getActions().get(i));
        }
    }

    public void remove(AdapterItem item) {
        this.objects.remove(item);
    }

    public AdapterItem get(int index) {
        return this.objects.get(index);
    }

    public void clear() {
        this.objects.clear();
    }

    public int size() {
        return this.objects.size();
    }

    public void useComparator(Comparator comparator) {
        if (comparator != null) {
            Collections.sort(this.objects, comparator);
        }
    }

    public int getIndexOfItem(AdapterItem item) {
        return this.objects.indexOf(item);
    }

    public int getIndexOfItemWithSameId(AdapterItem item) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getId().equals(item.getId())) continue;
            return i;
        }
        return -1;
    }

    public void createComparatorFromActualItems() {
        this.comparator = new ItemsComparator(this.objects);
    }

    public void createComparatorForExactOrder() {
        this.comparatorForName = null;
        this.comparator = null;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Comparator getComparatorForColumnCreating() {
        return this.getComparator();
    }

    public int getInitIndex() {
        return this.initIndex;
    }

    public void setInitIndex(int initIndex) {
        this.initIndex = initIndex;
    }

    public AdapterActionCollection getActions() {
        return this.actions;
    }

    public void addAction(AdapterAction item) {
        this.actions.add(item);
    }

    public void setActions(AdapterActionCollection actions) {
        this.actions = actions;
    }

    public Comparator getComparatorForName() {
        return this.comparatorForName;
    }

    public void setComparatorForName(Comparator comparatorForName) {
        this.comparatorForName = comparatorForName;
    }

    public boolean isNoSearch() {
        return this.noSearch;
    }

    public void setNoSearch(boolean noSearch) {
        this.noSearch = noSearch;
    }

    public ArrayList<AdapterItem> getObjects() {
        return this.objects;
    }

    public void setObjects(ArrayList<AdapterItem> objects) {
        this.objects = objects;
    }

    public String getContextLabel() {
        return this.contextLabel;
    }

    public void setContextLabel(String contextLabel) {
        this.contextLabel = contextLabel;
    }

    public Exception getContextLabelError() {
        return this.contextLabelError;
    }

    public void setContextLabelError(Exception contextLabelError) {
        this.contextLabelError = contextLabelError;
    }

    private class ExactOrderItemsComparator
    implements Comparator {
        private List<AdapterItem> items;

        public ExactOrderItemsComparator(ArrayList<AdapterItem> items) {
            this.items = items;
        }

        public int compare(Object o1, Object o2) {
            int index1 = 0;
            int index2 = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                AdapterItem item = this.items.get(i);
                if (item == o1) {
                    index1 = i;
                }
                if (item != o2) continue;
                index2 = i;
            }
            return new Integer(index1).compareTo(index2);
        }
    }

    private class ItemsComparator
    implements Comparator {
        private List<Class> classes = new ArrayList<Class>();

        public ItemsComparator(ArrayList<AdapterItem> objects) {
            for (AdapterItem item : objects) {
                if (this.classes.contains(item.getClass())) continue;
                this.classes.add(item.getClass());
            }
        }

        public int compare(Object o1, Object o2) {
            int index1 = this.classes.indexOf(o1.getClass());
            int index2 = this.classes.indexOf(o2.getClass());
            return new Integer(index1).compareTo(index2);
        }
    }
}

