/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.ColumnResolver;
import java.util.Comparator;

public class AdapterItemComparator
implements Comparator {
    private Comparator first;
    private Comparator second;
    private boolean ascendent;
    private ColumnResolver resolver;
    private int column;

    public AdapterItemComparator(Comparator first, Comparator second, boolean ascendent, ColumnResolver resolver, int column) {
        this.first = first;
        this.second = second;
        this.ascendent = ascendent;
        this.resolver = resolver;
        this.column = column;
    }

    public int compare(Object o1, Object o2) {
        try {
            if (this.column == 0) {
                return 0;
            }
            int result = this.first.compare(o1, o2);
            if (result == 0) {
                AdapterItem item1 = (AdapterItem)o1;
                AdapterItem item2 = (AdapterItem)o2;
                if (this.column == 1) {
                    result = this.second.compare(item1.getName(), item2.getName());
                } else {
                    Object val1 = this.resolver.getValueForColumn(this.column - 2, item1);
                    Object val2 = this.resolver.getValueForColumn(this.column - 2, item2);
                    result = this.second.compare(val1, val2);
                }
                if (!this.ascendent) {
                    result = -1 * result;
                }
            }
            return result;
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

