/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.CommanderPlugModelHandler;
import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.Flavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.FlavouredItemCollection;
import com.browsersoft.commander.model.NamedItem;
import com.browsersoft.commander.model.OperationWorkerHandler;
import com.browsersoft.commander.model.SearchProgressHandler;
import com.browsersoft.commander.model.adapter.AdapterAction;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.AdapterItemsWrapper;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import com.browsersoft.commander.model.plugin.PluginCollection;
import com.browsersoft.commander.utils.ClipboardUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AdapterLayer
implements CommanderPlugModel {
    private CommanderAdapter adapter;
    private AdapterPath path = new AdapterPath();
    private CommanderPlugModelHandler handler;
    private CommanderPlugStorageModel storageModel;
    private AdapterItemsWrapper itemsWrapper;

    public AdapterLayer(CommanderAdapter adapter) throws Exception {
        this.adapter = adapter;
        adapter.setAdapterLayer(this);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        try {
            return this.itemsWrapper.getTableRenderer(row, column);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        try {
            return this.itemsWrapper.getTableEditor(row, column);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void reload() throws Exception {
        this.itemsWrapper.reload();
        this.itemsWrapper.sortColumn(1, true);
        this.handler.refreshUI();
    }

    public void reconnect() throws Exception {
        this.handler.reconnect();
    }

    @Override
    public void switchToDisc(Object disc, PluginCollection plugins) throws Exception {
        this.path.clear();
        this.path.add((AdapterItem)disc);
        this.itemsWrapper = new AdapterItemsWrapper(this.adapter.go(this.path), this.path, this.adapter, plugins);
    }

    @Override
    public String getActualPathForHuman() throws Exception {
        return this.path.toString();
    }

    @Override
    public String getContextLabel() throws Exception {
        return this.itemsWrapper.getContextLabel();
    }

    @Override
    public Exception getContextLabelError() throws Exception {
        return this.itemsWrapper.getContextLabelError();
    }

    @Override
    public String[] getActualIdsPath() throws Exception {
        return this.path.toIdPath();
    }

    @Override
    public void search(String text, SearchProgressHandler searchHandler) throws Exception {
        this.itemsWrapper.search(text, searchHandler, this.handler);
        this.handler.refreshUI();
    }

    @Override
    public void setActualIdsPath(String[] actualIdsPath) throws Exception {
        for (String item : actualIdsPath) {
            this.itemsWrapper.goInto(item);
        }
        this.handler.refreshUI();
    }

    @Override
    public void showPopup(Component component, Point point, int onIndex) throws Exception {
        AdapterItem item;
        if (onIndex >= 0 && onIndex < this.itemsWrapper.getSize() && (item = this.itemsWrapper.getItem(onIndex)) != null) {
            JPopupMenu menu = this.constructPopupMenu(item);
            List<JMenuItem> items = item.getPopupMenuItems(this.handler);
            if (items != null) {
                menu.add(new JSeparator());
                for (JMenuItem menuItem : items) {
                    menu.add(menuItem);
                }
            }
            menu.show(component, point.x, point.y);
        }
    }

    private JPopupMenu constructPopupMenu(final AdapterItem item) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyNameItem = new JMenuItem();
        copyNameItem.setText("Copy name to clipboard");
        copyNameItem.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/model/adapter/copy.png")));
        copyNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipboardUtils.setPlainTextClipboard(item.getNameForPath());
            }
        });
        popupMenu.add(copyNameItem);
        JMenuItem copyPathToClipboard = new JMenuItem();
        copyPathToClipboard.setText("Copy path to clipboard");
        copyPathToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/model/adapter/copy.png")));
        copyPathToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fullPath = AdapterLayer.this.path.toFullNamePath();
                ClipboardUtils.setPlainTextClipboard(fullPath + (fullPath.endsWith("/") ? "" : "/") + item.getNameForPath());
            }
        });
        popupMenu.add(copyPathToClipboard);
        JMenuItem copyIdPathToClipboard = new JMenuItem();
        copyIdPathToClipboard.setText("Copy id path to clipboard");
        copyIdPathToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/model/adapter/copy.png")));
        copyIdPathToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fullPath = AdapterLayer.this.path.toFullPath();
                ClipboardUtils.setPlainTextClipboard(fullPath + (fullPath.endsWith("/") ? "" : "/") + item.getId());
            }
        });
        popupMenu.add(copyIdPathToClipboard);
        JMenuItem openInOpositeSide = new JMenuItem();
        openInOpositeSide.setText("Open in opposite window");
        openInOpositeSide.setIcon(item.getIcon());
        openInOpositeSide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AdapterLayer.this.handler.openInOpositeWindow(item.getId());
                }
                catch (Exception e) {
                    ErrorManager.notify(e);
                }
            }
        });
        popupMenu.add(openInOpositeSide);
        return popupMenu;
    }

    @Override
    public void selectionChanged(int[] indexis) throws Exception {
    }

    @Override
    public void setParentModelStorage(CommanderPlugStorageModel storage) {
        this.storageModel = storage;
    }

    @Override
    public CommanderPlugStorageModel getParentModelStorage() {
        return this.storageModel;
    }

    @Override
    public void setHandler(CommanderPlugModelHandler handler) {
        this.handler = handler;
    }

    @Override
    public CommanderPlugModelHandler getHandler() {
        return this.handler;
    }

    @Override
    public int getIndexOfItemStartWith(String text) {
        return this.itemsWrapper.getIndexOfItemStartWith(text);
    }

    @Override
    public Icon getActualRootIcon() {
        return this.path.getLast().getIcon();
    }

    @Override
    public int getInitColumnSize(int index) {
        try {
            return this.itemsWrapper.getInitColumnSize(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    @Override
    public void sortColumn(int index, boolean ascendent) throws Exception {
        this.itemsWrapper.sortColumn(index, ascendent);
    }

    @Override
    public void goInto(int index) throws Exception {
        if (index >= 0 && index < this.itemsWrapper.getSize()) {
            int indexForSelection = this.itemsWrapper.goInto(index);
            this.handler.refreshUI();
            if (indexForSelection >= 0 && indexForSelection < this.itemsWrapper.getSize()) {
                this.handler.setSelectionInterval(indexForSelection, indexForSelection);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.itemsWrapper.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.itemsWrapper.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            return this.itemsWrapper.getColumnName(columnIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        try {
            return this.itemsWrapper.getColumnClass(columnIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.class;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            return this.itemsWrapper.isCellEditable(rowIndex, columnIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.itemsWrapper.getValueAt(rowIndex, columnIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this.itemsWrapper.setValueAt(aValue, rowIndex, columnIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public FlavouredItemCollection getFlavouredItemsForCopy(int[] items, int action) throws Exception {
        if (this.itemsWrapper == null) {
            return null;
        }
        return this.itemsWrapper.getActionResolver().getFlavouredItemsForCopy(items, action);
    }

    @Override
    public boolean checkItemForCopy(FlavouredItem item, int action) throws Exception {
        return this.itemsWrapper.getActionResolver().checkItemForCopy(item, action);
    }

    @Override
    public void compare(Flavour flavour1, Flavour flavour2, int action) throws Exception {
        this.itemsWrapper.getActionResolver().compare(flavour1, flavour2, action);
    }

    @Override
    public boolean existItem(FlavouredItem item, int action) throws Exception {
        return this.itemsWrapper.getActionResolver().existItem(item, action);
    }

    @Override
    public void copyItem(FlavouredItem item, OperationWorkerHandler handler, int action) throws Exception {
        this.itemsWrapper.getActionResolver().copyItem(item, handler, action);
    }

    @Override
    public NamedItem getItemForMove(int item) throws Exception {
        return this.itemsWrapper.getActionResolver().getItemForMove(item);
    }

    @Override
    public void moveItem(NamedItem item, OperationWorkerHandler handler) throws Exception {
        this.itemsWrapper.getActionResolver().moveItem(item, handler);
    }

    @Override
    public boolean checkMove(NamedItem item) throws Exception {
        return this.itemsWrapper.getActionResolver().checkMove(item);
    }

    @Override
    public NamedItem getItemForDelete(int item) throws Exception {
        return this.itemsWrapper.getActionResolver().getItemForDelete(item);
    }

    @Override
    public void deleteItem(NamedItem item, OperationWorkerHandler handler) throws Exception {
        this.itemsWrapper.getActionResolver().deleteItem(item, handler);
    }

    @Override
    public NamedItem getItemForLink(int item) throws Exception {
        return this.itemsWrapper.getActionResolver().getItemForLink(item);
    }

    @Override
    public void linkItem(NamedItem item, OperationWorkerHandler handler) throws Exception {
        this.itemsWrapper.getActionResolver().linkItem(item, handler);
    }

    @Override
    public boolean checkLink(NamedItem item) throws Exception {
        return this.itemsWrapper.getActionResolver().checkLink(item);
    }

    @Override
    public int getNumberOfActions() {
        return this.itemsWrapper.getActionResolver().getNumberOfActions();
    }

    @Override
    public AdapterAction getAction(int index) {
        return this.itemsWrapper.getActionResolver().getAction(index);
    }

    @Override
    public int getActionKey(int index) {
        return this.itemsWrapper.getActionResolver().getActionKey(index);
    }

    @Override
    public String getActionName(int index) {
        return this.itemsWrapper.getActionResolver().getActionName(index);
    }

    @Override
    public Icon getActionIcon(int index) {
        return this.itemsWrapper.getActionResolver().getActionIcon(index);
    }

    @Override
    public String getActionDescription(int index) {
        return this.itemsWrapper.getActionResolver().getActionDescription(index);
    }

    @Override
    public int getActionType(int index) {
        return this.itemsWrapper.getActionResolver().getActionType(index);
    }

    @Override
    public Map<String, String> getActionVariations(int index) {
        return this.itemsWrapper.getActionResolver().getActionVariations(index);
    }

    @Override
    public boolean showDisabledDelete(int index) {
        return this.itemsWrapper.getActionResolver().showDisabledDelete(index);
    }

    @Override
    public boolean checkNew(int action) throws Exception {
        return this.itemsWrapper.getActionResolver().checkNew(action);
    }

    @Override
    public void doNew(Frame parent, int action) throws Exception {
        this.itemsWrapper.getActionResolver().doNew(parent, action);
    }

    @Override
    public String getActualPath() {
        return this.path.toString();
    }

    @Override
    public String getActualFullPath() {
        return this.path.toFullPath();
    }

    @Override
    public void doRun(Frame parent, int action, String variation) throws Exception {
        this.itemsWrapper.getActionResolver().doRun(parent, action, variation);
    }

    @Override
    public boolean checkRun(int action) throws Exception {
        return this.itemsWrapper.getActionResolver().checkRun(action);
    }

    @Override
    public boolean checkReorder(int actionIndex, int[] items, int after) throws Exception {
        return this.itemsWrapper.getActionResolver().checkReorder(actionIndex, items, after);
    }

    @Override
    public void reorder(int actionIndex, int[] items, int after) throws Exception {
        this.itemsWrapper.getActionResolver().reorder(actionIndex, items, after);
    }
}

