/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import java.util.ArrayList;
import java.util.List;

public class AdapterPath {
    private ArrayList<AdapterItem> objects = new ArrayList();
    private boolean searching;

    public void add(AdapterItem item) {
        this.objects.add(item);
    }

    public AdapterItem get(int index) {
        return this.objects.get(index);
    }

    public void clear() {
        this.objects.clear();
    }

    public int size() {
        return this.objects.size();
    }

    public void remove(int index) {
        this.objects.remove(index);
    }

    public AdapterItem removeLast() {
        AdapterItem item = this.objects.get(this.size() - 1);
        this.objects.remove(this.size() - 1);
        return item;
    }

    public AdapterItem getLast() {
        if (this.size() > 0) {
            return this.objects.get(this.size() - 1);
        }
        return null;
    }

    public AdapterPath getSubPathForSource(CommanderAdapter commanderAdapter) {
        AdapterPath newPath = new AdapterPath();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSourceAdapter() != commanderAdapter) continue;
            newPath.add(this.get(i));
        }
        return newPath;
    }

    public AdapterPath clonePath() {
        AdapterPath newPath = new AdapterPath();
        for (int i = 0; i < this.size(); ++i) {
            newPath.add(this.get(i));
        }
        return newPath;
    }

    public String toString() {
        String ret = "";
        int length = 0;
        for (int i = this.size() - 1; i >= 0; --i) {
            if ((length += this.get(i).getNameForPath().length() + 1) > 60) {
                ret = "../" + ret;
                return ret;
            }
            ret = this.get(i).getNameForPath() + "/" + ret;
        }
        return ret;
    }

    public String[] toIdPath() {
        String[] ids = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ids[i] = this.get(i).getId();
        }
        return ids;
    }

    public String toFullPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(this.get(i).getId());
            if (i == this.size() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public String toFullNamePath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(this.get(i).getName());
            if (i == this.size() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public List<String> toListOfIdPath() {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            ids.add(this.get(i).getId());
        }
        return ids;
    }

    public boolean isSearching() {
        return this.searching;
    }

    public void setSearching(boolean searching) {
        this.searching = searching;
    }
}

