/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.ErrorNotifier;
import com.browsersoft.commander.model.SearchProgressHandler;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterLayer;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.utils.StringUtils;
import java.util.List;
import javax.swing.JMenu;

public abstract class CommanderAdapter {
    private DocumentManager documentManager;
    private ErrorNotifier errorNotifier;
    private AdapterLayer adapterLayer;

    public void connect() throws Exception {
    }

    public void profilesChanged(List<CommanderAdapter> otherAdapters) throws Exception {
    }

    public void disconnect() throws Exception {
    }

    public boolean checkRemoteUpdates() {
        return false;
    }

    public boolean hasRemoteUpdates() {
        return false;
    }

    public JMenu getMenu(String name) {
        return null;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public abstract AdapterItemCollection go(AdapterPath var1) throws Exception;

    public AdapterItemCollection search(AdapterPath path, String text, SearchProgressHandler searchHandler) throws Exception {
        AdapterItemCollection ret = new AdapterItemCollection();
        AdapterPath newPath = path.clonePath();
        newPath.setSearching(true);
        this.search(path, text, ret, searchHandler);
        searchHandler.searchDone();
        return ret;
    }

    private boolean search(AdapterPath path, String text, AdapterItemCollection ret, SearchProgressHandler searchHandler) throws Exception {
        if (!searchHandler.searchRunning(-1, path.toString())) {
            return false;
        }
        AdapterItemCollection adapterItemCollection = this.go(path);
        if (adapterItemCollection != null) {
            AdapterItem adapterItem;
            int i;
            for (i = 0; i < adapterItemCollection.size(); ++i) {
                adapterItem = adapterItemCollection.get(i);
                if (!this.checkItem(adapterItem, text)) continue;
                ret.add(adapterItem);
            }
            for (i = 0; i < adapterItemCollection.size(); ++i) {
                adapterItem = adapterItemCollection.get(i);
                AdapterPath newPath = path.clonePath();
                newPath.setSearching(true);
                newPath.add(adapterItem);
                adapterItem.setLocation(newPath);
                if (this.search(newPath, text, ret, searchHandler)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkItem(AdapterItem adapterItem, String text) {
        return StringUtils.wildCardMatch(text, adapterItem.getNameForPath());
    }

    public void reloadModules() throws Exception {
        this.adapterLayer.reconnect();
    }

    public ErrorNotifier getErrorNotifier() {
        return this.errorNotifier;
    }

    public void setErrorNotifier(ErrorNotifier errorNotifier) {
        this.errorNotifier = errorNotifier;
    }

    public AdapterLayer getAdapterLayer() {
        return this.adapterLayer;
    }

    public void setAdapterLayer(AdapterLayer adapterLayer) {
        this.adapterLayer = adapterLayer;
    }
}

