/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.CommanderPlugModelHandler;
import com.browsersoft.commander.model.ErrorNotifier;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.Column;
import com.browsersoft.commander.model.adapter.ColumnName;
import com.browsersoft.commander.model.adapter.ColumnPosition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class SearchResultAdapterItem
extends AdapterItem {
    private AdapterItem adapterItem;
    private ErrorNotifier errorNotifier;
    private CommanderPlugModelHandler handler;

    public SearchResultAdapterItem(AdapterItem adapterItem, ErrorNotifier errorNotifier, CommanderPlugModelHandler handler) {
        this.adapterItem = adapterItem;
        this.errorNotifier = errorNotifier;
        this.handler = handler;
    }

    public AdapterItem getInnerAdapterItem() {
        return this.adapterItem;
    }

    @Override
    public List<JMenuItem> getPopupMenuItems(CommanderPlugModelHandler handler) {
        if (this.adapterItem.getLocation() != null) {
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText("Go to original location");
            menuItem.setIcon(this.adapterItem.getIcon());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SearchResultAdapterItem.this.goToLocation();
                    }
                    catch (Exception ex) {
                        SearchResultAdapterItem.this.errorNotifier.notify(ex);
                    }
                }
            });
            items.add(menuItem);
            List<JMenuItem> itemsInAdapter = this.adapterItem.getPopupMenuItems(handler);
            if (itemsInAdapter != null) {
                items.addAll(itemsInAdapter);
            }
            return items;
        }
        return null;
    }

    private void goToLocation() throws Exception {
        if (this.adapterItem.getLocation() != null) {
            this.handler.openPath(this.adapterItem.getLocation().toListOfIdPath(), true);
        }
    }

    @Override
    public Icon getIcon() {
        return this.adapterItem.getIcon();
    }

    @Override
    public String getName() {
        return this.adapterItem.getNameForPath();
    }

    @Override
    public String getNameForPath() {
        return this.adapterItem.getNameForPath();
    }

    @Override
    public String getId() {
        return this.adapterItem.getId();
    }

    @Column
    @ColumnPosition(value=0)
    @ColumnName(value="Location")
    public String getLoc() {
        if (this.adapterItem.getLocation() != null) {
            return this.adapterItem.getLocation().toString();
        }
        return "?";
    }

    public void setErrorNotifier(ErrorNotifier errorNotifier) {
        this.errorNotifier = errorNotifier;
    }
}

