/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.adapter.ActionUtils;
import com.browsersoft.commander.utils.forms.ValidFormObject;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SimpleNewDialog
extends CenteredDialog {
    private String name;
    private JButton buttonCancel;
    private JButton buttonOK;
    private JLabel lblNewDirectory;
    private JTextField txtDirectoryName;
    private JLabel errorTextField;
    private ValidFormObject formValidator;

    public SimpleNewDialog(Frame parent, String title, String text) {
        super(parent, true);
        this.initComponents();
        this.centerParent();
        this.setTitle(title);
        this.lblNewDirectory.setText(text);
        this.lblNewDirectory.setFont(new Font("Arial Unicode MS", 0, 12));
        this.txtDirectoryName.setFont(new Font("Arial Unicode MS", 0, 12));
        this.setFormValidator(() -> {
            boolean isValid = true;
            if (!ActionUtils.isValidActionDialogInput(this.txtDirectoryName.getText())) {
                isValid = false;
                this.showErrorMsg("Input element cannot be empty or contain forbidden characters.");
            }
            return isValid;
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.txtDirectoryName.setText(name);
    }

    public void showErrorMsg(String text) {
        this.errorTextField.setText(text);
        this.errorTextField.setVisible(true);
        this.revalidate();
        this.pack();
    }

    private void doOK() {
        this.name = this.txtDirectoryName.getText();
        if (!this.formValidator.isValidForm()) {
            return;
        }
        this.dispose();
    }

    private void doCancel() {
        this.name = null;
        this.dispose();
    }

    private void initComponents() {
        this.txtDirectoryName = new JTextField();
        this.lblNewDirectory = new JLabel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.errorTextField = new JLabel();
        this.errorTextField.setFont(new Font("Arial Unicode MS", 0, 12));
        this.errorTextField.setForeground(Color.RED);
        this.errorTextField.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.setTitle("New directory");
        this.setResizable(false);
        this.lblNewDirectory.setText("New directory");
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(evt -> this.doOK());
        this.buttonOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleNewDialog.this.buttonOKKeyPressed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(evt -> this.doCancel());
        this.buttonCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleNewDialog.this.buttonCancelKeyPressed(evt);
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleNewDialog.this.doCancel();
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleNewDialog.this.doOK();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNewDirectory).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.buttonOK, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(this.txtDirectoryName, -2, 350, -2).addComponent(this.errorTextField, -2, 350, -2))).addContainerGap(23, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblNewDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtDirectoryName, -2, -1, -2).addGap(5).addComponent(this.errorTextField, -2, -1, -2).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonCancelKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doCancel();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    private void buttonOKKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doOK();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    public void setFormValidator(ValidFormObject formValidator) {
        this.formValidator = formValidator;
    }
}

