/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class CommandExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result exec(String[] cmdArr, Map<String, String> envp, File dir) throws Exception {
        int exitVal;
        BufferedReader input = null;
        BufferedReader errInput = null;
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder errBuilder = new StringBuilder();
        try {
            String line;
            String[] env = CommandExecutor.prepareEnvironment(envp);
            Process pr = Runtime.getRuntime().exec(cmdArr, env, dir);
            input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = input.readLine()) != null) {
                outBuilder.append(line).append("\n");
            }
            exitVal = pr.waitFor();
            if (exitVal != 0) {
                String errLine;
                errInput = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
                while ((errLine = errInput.readLine()) != null) {
                    errBuilder.append(errLine).append("\n");
                }
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (errInput != null) {
                try {
                    errInput.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new Result(exitVal, outBuilder.toString(), errBuilder.toString());
    }

    protected static String[] prepareEnvironment(Map<String, String> envp) {
        String[] env = null;
        if (envp != null) {
            HashMap<String, String> envs = new HashMap<String, String>(System.getenv());
            for (Map.Entry<String, String> envpItem : envp.entrySet()) {
                envs.put(envpItem.getKey(), envpItem.getValue());
            }
            int i = 0;
            env = new String[envs.size()];
            for (Map.Entry envItem : envs.entrySet()) {
                env[i] = (String)envItem.getKey() + "=" + (String)envItem.getValue();
                ++i;
            }
        }
        return env;
    }

    public static class Result {
        private final String out;
        private final String err;
        private final int returnCode;

        public Result(int returnCode, String out, String err) {
            this.returnCode = returnCode;
            this.out = out;
            this.err = err;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public String getOut() {
            return this.out;
        }

        public String getErr() {
            return this.err;
        }
    }
}

