/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileUtils {
    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getDirectoryFromURL(String url) {
        int start = url.lastIndexOf(47);
        if (start >= 0) {
            return url.substring(0, start + 1);
        }
        return url;
    }

    public static boolean copyFile2File(File inputFile, File outputFile) throws Exception {
        byte[] buffer = new byte[2000];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        int m_length = 0;
        while ((m_length = in.read(buffer)) != -1) {
            out.write(buffer, 0, m_length);
        }
        out.close();
        in.close();
        return true;
    }

    public static String loadFileToString(File sFile) throws Exception {
        String s;
        BufferedReader in = new BufferedReader(new FileReader(sFile));
        StringBuffer out = new StringBuffer();
        while ((s = in.readLine()) != null) {
            out.append(s);
            out.append('\n');
        }
        return out.toString();
    }

    public static String loadInputStreamToString(InputStream in, String charset) throws IOException {
        String thisLine;
        InputStreamReader isReader = new InputStreamReader(in, charset);
        BufferedReader bReader = new BufferedReader(isReader);
        StringBuffer result = new StringBuffer();
        while ((thisLine = bReader.readLine()) != null) {
            result.append(thisLine + "\n");
        }
        return result.toString();
    }

    public static void saveStringToFileWithEncoding(File file, String sStr, String encoding) throws Exception {
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(sStr.getBytes(encoding));
        stream.close();
    }

    public static String getFileNameWithoutExtension(String nameFile) {
        int start = nameFile.lastIndexOf(46);
        if (start > 0) {
            return nameFile.substring(0, start);
        }
        return nameFile;
    }

    public static String getExtension(String nameFile) {
        int start = nameFile.lastIndexOf(46);
        if (start > 0) {
            return nameFile.substring(start + 1);
        }
        return "";
    }

    public static String getNameFileFromURL(String url) {
        int start = url.lastIndexOf(47);
        if (start > 0) {
            return url.substring(start + 1);
        }
        return url;
    }
}

