/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import com.browsersoft.commander.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarHashUtils {
    private static String ALGORITHM = "SHA";

    public static String computeJarHash(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (entries.hasMoreElements()) {
            int c;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !FileUtils.getExtension(entry.getName()).equals("class")) continue;
            buffer.write(entry.getName().getBytes("UTF-8"));
            InputStream inputStream = zipFile.getInputStream(entry);
            while ((c = inputStream.read()) != -1) {
                buffer.write((char)c);
            }
        }
        return JarHashUtils.computeHash(new ByteArrayInputStream(buffer.toByteArray()));
    }

    public static String computeHash(InputStream s) throws IOException {
        int ret;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = new byte[4096];
        while ((ret = s.read(buffer)) >= 0) {
            md.update(buffer, 0, ret);
        }
        byte[] hash = md.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            hexString.append(Integer.toOctalString(0xFF & hash[i]));
        }
        return hexString.toString();
    }
}

