/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

public class OSValidator {
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static String getOS() {
        if (OSValidator.isWindows()) {
            return "win";
        }
        if (OSValidator.isMac()) {
            return "osx";
        }
        if (OSValidator.isUnix()) {
            return "unix";
        }
        if (OSValidator.isSolaris()) {
            return "solaris";
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(OS);
        if (OSValidator.isWindows()) {
            System.out.println("This is Windows");
        } else if (OSValidator.isMac()) {
            System.out.println("This is Mac");
        } else if (OSValidator.isUnix()) {
            System.out.println("This is Unix or Linux");
        } else if (OSValidator.isSolaris()) {
            System.out.println("This is Solaris");
        } else {
            System.out.println("Your OS is not support!!");
        }
    }
}

