/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static void unpackZip(File file, File destication) throws IOException {
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            File outFile = new File(destication, entry.getName());
            outFile.getParentFile().mkdirs();
            ZipUtil.inputStreamToOutputStream(zip.getInputStream(entry), new FileOutputStream(outFile), 2000);
        }
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.close();
        inputStream.close();
    }

    public static InputStream openInputStream(ZipEntry zipEntry, InputStream inputStream) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(zipEntry.getName())) continue;
            return zis;
        }
        return null;
    }

    public static List<ZipEntry> getZipEntriesInEntry(ZipFile zipFile, String path) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtil.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtil.getNumberOfSlashs(path) != ZipUtil.getNumberOfSlashs(name) || path.equals(name) || !name.startsWith(path)) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static List<ZipEntry> getZipEntriesInEntryDeep(ZipFile zipFile, ZipEntry entry) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        zipEntries.add(entry);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtil.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtil.getNumberOfSlashs(entry.getName()) > ZipUtil.getNumberOfSlashs(name) || entry.getName().equals(name) || !name.startsWith(entry.getName())) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static int getNumberOfSlashs(String s) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '/') continue;
            ++counter;
        }
        return counter;
    }

    public static String getNameWithoutSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

