/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.ComboBoxFormElementItem;
import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultipleChoiceFormElement
extends JList
implements FormElement {
    private FormElementHandler handler;
    private boolean changed;

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public MultipleChoiceFormElement(int visibleRowCount, String[] values, String[] titles) {
        MyListModel model = new MyListModel(values, titles);
        this.setModel(model);
        this.setSelectionMode(2);
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MultipleChoiceFormElement.this.generateChangeEvent();
            }
        });
        this.setBorder(new LineBorder(new Color(128, 128, 128), 1));
    }

    @Override
    public void destroy() {
    }

    private void generateChangeEvent() {
        if (this.handler != null) {
            this.handler.dataChanged();
        }
        this.changed = true;
    }

    @Override
    public FormElementHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getFormValue() {
        MyListModel myListModel = (MyListModel)this.getModel();
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!this.isSelectedIndex(i)) continue;
            values.add(myListModel.getId(i));
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            buffer.append((String)values.get(i));
            if (i == values.size() - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    @Override
    public void setFormValue(String value) {
        String[] items;
        MyListModel myListModel = (MyListModel)this.getModel();
        for (String item : items = value.split(",")) {
            for (int i = 0; i < myListModel.getSize(); ++i) {
                if (!item.equals(myListModel.getId(i))) continue;
                this.addSelectionInterval(i, i);
            }
        }
    }

    @Override
    public void enableEdit(boolean value) {
        this.setEnabled(value);
    }

    class MyListModel
    implements ListModel {
        private ArrayList<ComboBoxFormElementItem> items = new ArrayList();

        public MyListModel(String[] values, String[] titles) {
            for (int i = 0; i < titles.length; ++i) {
                ComboBoxFormElementItem item = new ComboBoxFormElementItem();
                item.setValue(values[i]);
                item.setTitle(titles[i]);
                this.items.add(item);
            }
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        public String getId(int index) {
            return this.items.get(index).getValue();
        }

        public Object getElementAt(int index) {
            return this.items.get(index).getTitle();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

