/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import com.browsersoft.commander.utils.forms.TextLineNumber;
import com.browsersoft.commander.utils.swing.PDControlScrollPane;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTextPane;
import javax.swing.ViewportLayout;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextAreaFormElement
extends PDControlScrollPane
implements FormElement {
    private FormElementHandler handler;
    private boolean changed;
    private JTextPane textPane = new JTextPane();
    private String defaultValue = null;
    private boolean defaultValueSet = false;

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public TextAreaFormElement() {
        this.showLineNumbers(true);
        this.setViewportView(this.textPane);
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextAreaFormElement.this.generateChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextAreaFormElement.this.generateChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setBorder(new LineBorder(new Color(128, 128, 128), 1));
        this.textPane.setFont(new Font("Arial Unicode MS", 0, 11));
        this.textPane.setBackground(new Color(231, 231, 231));
    }

    public void compensateHorizontalScrollBarHeight() {
        this.getViewport().setLayout(new ViewportLayout(){

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension preferredViewSize = super.preferredLayoutSize(parent);
                Container viewportContainer = parent.getParent();
                if (viewportContainer != null && TextAreaFormElement.this.getHorizontalScrollBar().isVisible()) {
                    preferredViewSize.height += TextAreaFormElement.this.getHorizontalScrollBar().getHeight();
                }
                return preferredViewSize;
            }
        });
    }

    @Override
    public void destroy() {
    }

    private void generateChangeEvent() {
        String defaultValue;
        String value = this.getFormValue();
        if (value == null) {
            value = "";
        }
        if ((defaultValue = this.getDefaultValue()) == null) {
            defaultValue = "";
        }
        if (!value.equals(defaultValue)) {
            if (this.handler != null) {
                this.handler.dataChanged();
            }
            this.changed = true;
        } else {
            this.changed = false;
        }
    }

    protected String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public FormElementHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getFormValue() {
        return this.textPane.getText();
    }

    @Override
    public void setFormValue(String value) {
        if (!this.defaultValueSet) {
            this.defaultValueSet = true;
            this.defaultValue = value;
        }
        this.textPane.setText(value);
    }

    public void setEditable(boolean enabled) {
        this.textPane.setEditable(enabled);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    @Override
    public void enableEdit(boolean value) {
        this.textPane.setEnabled(value);
    }

    public void setTextPane(JTextPane textPane) {
        this.textPane = textPane;
    }

    public void showLineNumbers(boolean enabled) {
        if (enabled) {
            this.setRowHeaderView(new TextLineNumber(this.textPane));
        } else {
            this.setRowHeader(null);
        }
    }
}

