/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.prefs;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class PreferencesUtil {
    Preferences myPref;
    private static final String COUNT = "Count";
    private static final String SIZE = "Size";
    private static final String PARAM = "PARAM";

    public PreferencesUtil(Class h) {
        this.myPref = Preferences.userNodeForPackage(h);
    }

    public HashMap readPreferences() throws BackingStoreException {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] Keys = this.myPref.keys();
        for (int i = 0; i < Keys.length; ++i) {
            String Val = this.myPref.get(Keys[i], "");
            map.put(Keys[i], Val);
        }
        return map;
    }

    public int countProfiles() throws BackingStoreException {
        HashMap HM = this.readPreferences();
        String count = (String)HM.get(COUNT);
        if (count == null) {
            return 0;
        }
        return Integer.parseInt(count);
    }

    public int sizeOfOneProfile() throws BackingStoreException {
        HashMap HM = this.readPreferences();
        String count = (String)HM.get(SIZE);
        if (count == null) {
            return 0;
        }
        return Integer.parseInt(count);
    }

    public String[][] getProfiles() throws BackingStoreException {
        HashMap HM = this.readPreferences();
        int count = this.countProfiles();
        int size = this.sizeOfOneProfile();
        String[][] RA = new String[count][size];
        for (int j = 0; j < count; ++j) {
            for (int i = 0; i < size; ++i) {
                String param = (String)HM.get(PARAM + i + "_" + j);
                if (param == null) {
                    param = "";
                }
                RA[j][i] = param;
            }
        }
        return RA;
    }

    public void setProfiles(String[][] params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(COUNT, String.valueOf(params.length));
        if (params.length > 0) {
            map.put(SIZE, String.valueOf(params[0].length));
        }
        for (int j = 0; j < params.length; ++j) {
            for (int i = 0; i < params[0].length; ++i) {
                map.put(PARAM + i + "_" + j, params[j][i]);
            }
        }
        this.setPreferences(map);
    }

    public void setPreference(String Key2, String Value) {
        this.myPref.put(Key2, Value);
    }

    public String getPreference(String Key2) {
        return this.myPref.get(Key2, "");
    }

    public void setPreferences(HashMap map) {
        for (Object o : map.keySet()) {
            String Key2 = (String)o;
            this.myPref.put(Key2, (String)map.get(Key2));
        }
    }

    public void exportPreferences(String FilePath) throws BackingStoreException, IOException {
        this.myPref.exportSubtree(new FileOutputStream(FilePath));
    }

    public void importPreferences(String FilePath) throws IOException, InvalidPreferencesFormatException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(FilePath));
        Preferences.importPreferences(is);
    }
}

