/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class ButtonPanel
extends JPanel {
    private final List<JButton> buttons = new LinkedList<JButton>();
    private final JPanel buttonPanel;
    private JPopupMenu popup;
    private final JButton showButton;
    private int HORIZONTAL_PADDING = 5;
    private int VERTICAL_PADDING = 5;
    private int lastX = this.HORIZONTAL_PADDING;

    public ButtonPanel() {
        super(new BorderLayout());
        this.buttonPanel = new JPanel(null);
        this.buttonPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ButtonPanel.this.hideAndShowButtons();
            }
        });
        this.popup = new JPopupMenu();
        this.showButton = new JButton(">>");
        this.showButton.setVisible(false);
        this.showButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ButtonPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        JPanel showButtonPanel = new JPanel(null);
        showButtonPanel.add(this.showButton);
        this.showButton.setBounds(this.HORIZONTAL_PADDING, this.VERTICAL_PADDING, this.showButton.getPreferredSize().width, this.showButton.getPreferredSize().height + 3);
        showButtonPanel.setPreferredSize(new Dimension(this.showButton.getPreferredSize().width + 2 * this.HORIZONTAL_PADDING, this.showButton.getPreferredSize().height + 2 * this.VERTICAL_PADDING));
        super.add(this.buttonPanel);
        super.add((Component)showButtonPanel, "East");
    }

    public void addButton(JButton button) {
        this.addButton(button, true);
    }

    public void addButton(JButton button, boolean addPopupItem) {
        this.buttons.add(button);
        this.buttonPanel.add(button);
        button.setBounds(this.lastX, this.VERTICAL_PADDING, button.getPreferredSize().width, button.getPreferredSize().height);
        this.lastX = this.lastX + button.getPreferredSize().width + this.HORIZONTAL_PADDING;
        if (addPopupItem) {
            ActionListener[] actionListeners;
            JMenuItem menuItem = new JMenuItem(button.getText());
            menuItem.setIcon(button.getIcon());
            for (ActionListener actionListener : actionListeners = button.getActionListeners()) {
                menuItem.addActionListener(actionListener);
            }
            this.popup.add(menuItem);
        }
        this.hideAndShowButtons();
    }

    public void addPopupItem(JMenuItem menuItem) {
        this.popup.add(menuItem);
        this.hideAndShowButtons();
    }

    public void removeAllButtons() {
        this.buttonPanel.removeAll();
        this.popup.removeAll();
        this.buttons.clear();
        this.lastX = this.HORIZONTAL_PADDING;
    }

    private void hideAndShowButtons() {
        if (this.buttons.size() == 0) {
            return;
        }
        int wholeWidth = this.getWidth();
        int buttonPanelWidth = this.buttonPanel.getWidth();
        boolean somethingHidden = false;
        JButton button = this.buttons.get(this.buttons.size() - 1);
        int maxX = button.getX() + button.getWidth();
        if (maxX > wholeWidth) {
            button.setVisible(false);
            somethingHidden = true;
        } else {
            button.setVisible(true);
        }
        for (int i = this.buttons.size() - 2; i >= 0; --i) {
            button = this.buttons.get(i);
            maxX = button.getX() + button.getWidth();
            if (maxX > buttonPanelWidth) {
                button.setVisible(false);
                somethingHidden = true;
                continue;
            }
            button.setVisible(true);
        }
        boolean hasSubMenu = false;
        for (MenuElement menuElement : this.popup.getSubElements()) {
            if (!(menuElement instanceof JMenu)) continue;
            hasSubMenu = true;
            break;
        }
        if (somethingHidden || hasSubMenu) {
            this.showButton.setVisible(true);
        } else {
            this.showButton.setVisible(false);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(400, 300);
        frame.setDefaultCloseOperation(3);
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addButton(new JButton("ahoj1"));
        buttonPanel.addButton(new JButton("ahoj2"));
        buttonPanel.addButton(new JButton("ahoj3"));
        buttonPanel.addButton(new JButton("ahoj4"));
        frame.getContentPane().add(buttonPanel);
        frame.setVisible(true);
    }
}

