/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MemoryPanel
extends JPanel {
    private JProgressBar memoryBar = new JProgressBar();
    private static final int TIME = 1000;
    private Timer timer;

    public MemoryPanel() {
        super(new BorderLayout());
        this.memoryBar.setPreferredSize(new Dimension(100, 20));
        this.setMaximumSize(new Dimension(100, 25));
        this.memoryBar.setStringPainted(true);
        this.memoryBar.setBorderPainted(false);
        JPanel memoryPanel = new JPanel(new BorderLayout());
        memoryPanel.add(this.memoryBar);
        this.add((Component)memoryPanel, "Center");
        memoryPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.gc();
            }
        });
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                long totalMemLong = Runtime.getRuntime().totalMemory();
                long freeMemLong = Runtime.getRuntime().freeMemory();
                long usedMemLong = totalMemLong - freeMemLong;
                int totalMem = (int)Math.ceil((double)totalMemLong / 1048576.0);
                int usedMem = (int)Math.ceil((double)usedMemLong / 1048576.0);
                MemoryPanel.this.memoryBar.setMaximum((int)(totalMemLong / 1024L));
                MemoryPanel.this.memoryBar.setValue((int)(usedMemLong / 1024L));
                MemoryPanel.this.memoryBar.setString(usedMem + "M of " + totalMem + "M");
            }
        });
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    public void startTimer() {
        this.timer.start();
    }
}

