/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PDControlScrollPane
extends JScrollPane {
    public PDControlScrollPane() {
        this.addMouseWheelListener(new PDMouseWheelListener());
    }

    class PDMouseWheelListener
    implements MouseWheelListener {
        private JScrollBar bar;
        private int previousValue = 0;
        private JScrollPane parentScrollPane;

        private JScrollPane getParentScrollPane() {
            if (this.parentScrollPane == null) {
                Container parent;
                for (parent = PDControlScrollPane.this.getParent(); !(parent instanceof JScrollPane) && parent != null; parent = parent.getParent()) {
                }
                this.parentScrollPane = (JScrollPane)parent;
            }
            return this.parentScrollPane;
        }

        public PDMouseWheelListener() {
            this.bar = PDControlScrollPane.this.getVerticalScrollBar();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JScrollPane parent = this.getParentScrollPane();
            if (parent != null) {
                if (e.getWheelRotation() < 0) {
                    if (this.bar.getValue() == 0 && this.previousValue == 0) {
                        parent.dispatchEvent(this.cloneEvent(e));
                    }
                } else if (this.bar.getValue() == this.getMax() && this.previousValue == this.getMax()) {
                    parent.dispatchEvent(this.cloneEvent(e));
                }
                this.previousValue = this.bar.getValue();
            } else {
                PDControlScrollPane.this.removeMouseWheelListener(this);
            }
        }

        private int getMax() {
            return this.bar.getMaximum() - this.bar.getVisibleAmount();
        }

        private MouseWheelEvent cloneEvent(MouseWheelEvent e) {
            return new MouseWheelEvent((Component)this.getParentScrollPane(), e.getID(), e.getWhen(), e.getModifiers(), 1, 1, e.getClickCount(), false, e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        }
    }
}

