/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TwoColumnsLayout
implements LayoutManager {
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private int sizeOfFirstColumn;
    private int gapX;
    private int gapY;

    public TwoColumnsLayout(int sizeOfFirstColumn, int gapX, int gapY) {
        this.sizeOfFirstColumn = sizeOfFirstColumn;
        this.gapX = gapX;
        this.gapY = gapY;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.getComponentCount();
        this.preferredWidth = 0;
        this.preferredHeight = this.gapY;
        this.minWidth = 0;
        this.minHeight = 0;
        this.preferredWidth = parent.getSize().width;
        for (int i = 0; i < nComps; i += 2) {
            Component firstColumnComponent = parent.getComponent(i);
            Component secondColumnComponent = parent.getComponent(i + 1);
            Dimension firstDimension = firstColumnComponent.getPreferredSize();
            Dimension secondDimension = secondColumnComponent.getPreferredSize();
            this.preferredHeight += Math.max(firstDimension.height, secondDimension.height);
            this.preferredHeight += this.gapY * 2;
        }
        this.minHeight = this.preferredHeight;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.preferredWidth;
        dim.height = this.preferredHeight;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        dim.width = this.minWidth;
        dim.height = this.minHeight;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        int y = this.gapY;
        this.setSizes(parent);
        int parentWidth = parent.getSize().width;
        for (int i = 0; i < parent.getComponentCount(); i += 2) {
            Component firstColumnComponent = parent.getComponent(i);
            Component secondColumnComponent = parent.getComponent(i + 1);
            Dimension firstDimension = firstColumnComponent.getPreferredSize();
            Dimension secondDimension = secondColumnComponent.getPreferredSize();
            int maximumOfHeights = Math.max(firstDimension.height, secondDimension.height);
            firstColumnComponent.setBounds(this.gapX, y, this.sizeOfFirstColumn - 2 * this.gapX, maximumOfHeights);
            secondColumnComponent.setBounds(this.sizeOfFirstColumn + this.gapX, y, parentWidth - this.sizeOfFirstColumn - 2 * this.gapX, maximumOfHeights);
            y += maximumOfHeights + this.gapY * 2;
        }
    }
}

