/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private int gapX;
    private int gapY;

    public VerticalLayout(int gapX, int gapY) {
        this.gapX = gapX;
        this.gapY = gapY;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.getComponentCount();
        this.preferredWidth = 0;
        this.preferredHeight = this.gapY;
        this.minWidth = 0;
        this.minHeight = 0;
        this.preferredWidth = parent.getSize().width;
        for (int i = 0; i < nComps; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            this.preferredHeight += d.height;
            this.preferredHeight += this.gapY;
        }
        this.minHeight = this.preferredHeight;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        dim.width = this.preferredWidth;
        dim.height = this.preferredHeight;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        dim.width = this.minWidth;
        dim.height = this.minHeight;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        int y = this.gapY;
        this.setSizes(parent);
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            c.setBounds(this.gapX, y, parent.getSize().width - 2 * this.gapX, d.height);
            y += d.height + this.gapY;
        }
    }
}

