/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.universal;

import com.browsersoft.commander.utils.universal.FieldEditor;
import com.browsersoft.commander.utils.universal.FieldEditorHandler;
import com.browsersoft.commander.utils.universal.InvalidValueException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class CheckBoxEditor
extends JCheckBox
implements FieldEditor {
    private FieldEditorHandler handler;
    private boolean changed;

    public CheckBoxEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckBoxEditor.this.generateChangeEvent();
            }
        });
    }

    @Override
    public FieldEditorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FieldEditorHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getEditorValue() {
        return this.isSelected();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setEditorValue(Object value) {
        if (value instanceof Boolean) {
            this.setSelected((Boolean)value);
            return;
        } else {
            if (!(value instanceof String)) throw new InvalidValueException("CheckBoxEditor does not support value of type: " + value.getClass());
            String stringValue = (String)value;
            if (stringValue.equalsIgnoreCase("true")) {
                this.setSelected(true);
                return;
            } else {
                if (!stringValue.equalsIgnoreCase("false")) throw new InvalidValueException("CheckBoxEditor does not support string value: " + stringValue);
                this.setSelected(false);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setEnabled(readOnly);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private void generateChangeEvent() {
        this.changed = true;
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }
}

