/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.universal;

import com.browsersoft.commander.utils.universal.FieldEditor;
import com.browsersoft.commander.utils.universal.FieldEditorHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ComboBoxEditor
extends JComboBox
implements FieldEditor {
    private FieldEditorHandler handler;
    private boolean changed;
    private String[] titles;
    private Object[] values;

    public ComboBoxEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxEditor.this.generateChangeEvent();
            }
        });
    }

    @Override
    public FieldEditorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FieldEditorHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getEditorValue() {
        Object selectedItem = this.getSelectedItem();
        for (int i = 0; i < this.titles.length; ++i) {
            if (!selectedItem.equals(this.titles[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public void setEditorValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            this.setSelectedItem(this.titles[i]);
            return;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setEnabled(readOnly);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private void generateChangeEvent() {
        this.changed = true;
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }

    public void setOptions(String[] titles, Object[] values) {
        this.titles = titles;
        this.values = values;
        this.setModel(new DefaultComboBoxModel<String>(titles));
    }
}

