/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.universal;

import com.browsersoft.commander.utils.universal.FieldEditor;
import com.browsersoft.commander.utils.universal.FieldEditorHandler;
import com.browsersoft.commander.utils.universal.InvalidValueException;
import com.browsersoft.commander.utils.universal.LimitDocument;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldEditor
extends JTextField
implements FieldEditor {
    private FieldEditorHandler handler;
    private boolean changed;
    private boolean isCharEditor;
    private LimitDocument limitDocument = new LimitDocument(-1);
    private int minLength = -1;
    private int maxLength = -1;
    private String onErrorValue = "???";

    public TextFieldEditor() {
        this.setDocument(this.limitDocument);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldEditor.this.generateChangeEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldEditor.this.generateChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldEditor.this.generateChangeEvent();
            }
        });
    }

    @Override
    public FieldEditorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FieldEditorHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getEditorValue() {
        String value;
        String string = value = this.checkValueValidity(this.getText()) ? this.getText() : this.onErrorValue;
        if (this.isCharEditor) {
            return Character.valueOf(value.charAt(0));
        }
        return value;
    }

    @Override
    public void setEditorValue(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (this.checkValueValidity(stringValue)) {
                this.setText(stringValue);
            } else {
                this.setText(this.onErrorValue);
            }
        } else if (value instanceof Character) {
            String stringValue = value.toString();
            if (this.checkValueValidity(stringValue)) {
                if (!stringValue.equals("\u0000")) {
                    this.setText(stringValue);
                }
            } else {
                this.setText(this.onErrorValue);
            }
        } else {
            throw new InvalidValueException("TextFieldEditor does not support value of type: " + value.getClass());
        }
    }

    private boolean checkValueValidity(String stringValue) {
        if (this.minLength > -1 && stringValue.length() < this.minLength) {
            return false;
        }
        return this.maxLength <= -1 || stringValue.length() <= this.maxLength;
    }

    public boolean isCharEditor() {
        return this.isCharEditor;
    }

    public void setCharEditor(boolean charEditor) {
        this.isCharEditor = charEditor;
    }

    @Override
    public boolean isReadOnly() {
        return this.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setEnabled(readOnly);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private void generateChangeEvent() {
        this.changed = true;
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this.limitDocument.setMaxLength(maxLength);
    }

    public String getOnErrorValue() {
        return this.onErrorValue;
    }

    public void setOnErrorValue(String onErrorValue) {
        this.onErrorValue = onErrorValue;
    }
}

