/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.AquaKeyBindings;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class AquaPlasticTextAreaUI
extends BasicTextAreaUI {
    public static ComponentUI createUI(JComponent c) {
        return new AquaPlasticTextAreaUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateBackground((JTextComponent)c);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propertyName = evt.getPropertyName();
        if ("editable".equals(propertyName) || "enabled".equals(propertyName)) {
            this.updateBackground((JTextComponent)evt.getSource());
        }
    }

    private void updateBackground(JTextComponent c) {
        Color background = c.getBackground();
        if (background instanceof UIResource) {
            Color newColor = null;
            if (!c.isEnabled()) {
                newColor = UIManager.getColor("TextArea.disabledBackground");
            }
            if (newColor == null && !c.isEditable()) {
                newColor = UIManager.getColor("TextArea.inactiveBackground");
            }
            if (newColor == null) {
                newColor = UIManager.getColor("TextArea.background");
            }
            if (newColor != null && newColor != background) {
                c.setBackground(newColor);
            }
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings bindings = AquaKeyBindings.instance();
        bindings.setDefaultAction(this.getKeymapName());
        JTextComponent c = this.getComponent();
        bindings.installAquaUpDownActions(c);
    }
}

