/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineProcess;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.LocalEngineRun;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.UserInfo;
import java.util.Date;
import java.util.List;

public class AsyncEngineProcess
implements EngineProcess {
    private EngineRun engineRun;

    public AsyncEngineProcess(EngineRun engineRun) {
        this.engineRun = engineRun;
    }

    @Override
    public String getConsole() throws Exception {
        List<Message> messages = this.engineRun.getConsole("");
        StringBuilder stringBuilder = new StringBuilder();
        for (Message message : messages) {
            stringBuilder.append(message.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<Message> getConsole(String lastMessageId) throws Exception {
        return this.engineRun.getConsole(lastMessageId);
    }

    @Override
    public EngineProcessState getState() throws Exception {
        return this.engineRun.getState();
    }

    @Override
    public void stopProcess(UserInfo userInfo) throws Exception {
        switch (this.getState()) {
            case STOPPED: {
                break;
            }
            case STARTING: 
            case STARTED: {
                try {
                    this.engineRun.stopEngine(userInfo);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void startProcess(UserInfo userInfo) throws Exception {
        switch (this.getState()) {
            case STOPPED: {
                if (this.engineRun instanceof LocalEngineRun) {
                    ((LocalEngineRun)this.engineRun).verifyRelease();
                }
                Thread runThread = new Thread("async::" + this.engineRun.getEngineId()){

                    @Override
                    public void run() {
                        try {
                            AsyncEngineProcess.this.engineRun.runEngine();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                runThread.setDaemon(true);
                runThread.start();
                break;
            }
            case STARTING: {
                break;
            }
        }
    }

    public void startProcess(UserInfo userInfo, int timeout) throws Exception {
        this.startProcess(userInfo);
        try {
            long engineStartTime = new Date().getTime();
            while (this.getState() != EngineProcessState.STARTED) {
                Thread.sleep(200L);
                if (new Date().getTime() - engineStartTime <= (long)timeout) continue;
                throw new Exception("Engine start timeout.");
            }
        }
        catch (Exception e) {
            this.stopProcess(userInfo);
            throw e;
        }
    }

    @Override
    public void restartProcess(UserInfo userInfo) {
        try {
            this.stopProcess(userInfo);
            while (this.getState() != EngineProcessState.STOPPED) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.startProcess(userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void killProcess(UserInfo userInfo) {
        try {
            this.engineRun.killEngine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeEngineCommand(final String command) {
        try {
            switch (this.getState()) {
                case STOPPED: {
                    if (this.engineRun instanceof LocalEngineRun) {
                        ((LocalEngineRun)this.engineRun).verifyRelease();
                    }
                    Thread runThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                AsyncEngineProcess.this.engineRun.executeEngineCommand(command);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    runThread.setDaemon(true);
                    runThread.start();
                    break;
                }
                case STARTING: {
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        return this.engineRun.handleStepRequest(boxId, o);
    }

    @Override
    public byte[] readFile(String name) throws Exception {
        return this.engineRun.readFile(name);
    }
}

