/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.FileInfo;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.HashException;
import com.browsersoft.config.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FileInfoList {
    private final Map<String, FileInfo> files = new HashMap<String, FileInfo>();

    private FileInfoList() {
    }

    public static FileInfoList forDirectory(String path) throws HashException {
        File[] files;
        FileInfoList fileInfoList = new FileInfoList();
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new RuntimeException("Path '" + directory.getAbsolutePath() + "' is not directory with jars!");
        }
        for (File file : files = directory.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            String name = file.getName();
            long size = file.length();
            String hash = Hash.toHex((byte[])Hash.forFile((File)file));
            fileInfoList.files.put(name, new FileInfo(name, size, hash));
        }
        return fileInfoList;
    }

    public String toXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<jarFiles>\n");
        for (FileInfo fileInfo : this.files.values()) {
            builder.append("  <jarFile name=\"").append(fileInfo.getName()).append("\" size=\"").append(fileInfo.getSize()).append("\" hash=\"").append(fileInfo.getHash()).append("\" />\n");
        }
        builder.append("</jarFiles>");
        return builder.toString();
    }

    public static FileInfoList fromXml(String xml) throws IOException, SAXException {
        FileInfoList fileInfoList = new FileInfoList();
        Element node = DOMUtils.loadFromString((String)xml).getDocumentElement();
        for (Node child : DOMUtils.getNodeChilds((Node)node, (String)"jarFile")) {
            String name = DOMUtils.getParameter((Node)child, (String)"name");
            long size = DOMUtils.getLongParameter((Node)child, (String)"size", (long)0L);
            String hash = DOMUtils.getParameter((Node)child, (String)"hash");
            fileInfoList.files.put(name, new FileInfo(name, size, hash));
        }
        return fileInfoList;
    }

    public void toXmlFile(String path) throws IOException {
        String xml = this.toXml();
        byte[] xmlBytes = xml.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
             FileOutputStream outputStream = new FileOutputStream(path);){
            StreamUtils.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public static FileInfoList fromXmlFile(String path) throws IOException, SAXException {
        byte[] xmlBytes;
        try (FileInputStream inputStream = new FileInputStream(path);){
            xmlBytes = StreamUtils.loadInputStreamToBytes((InputStream)inputStream);
        }
        String xml = new String(xmlBytes, StandardCharsets.UTF_8);
        return FileInfoList.fromXml(xml);
    }

    public Map<String, FileInfo> get() {
        return new HashMap<String, FileInfo>(this.files);
    }

    public static void main(String[] args) throws HashException, IOException {
        if (args.length == 3 && args[0].equals("generate")) {
            String directoryPath = args[1];
            String destinationPath = args[2];
            System.out.println("Generating jar files list of directory '" + directoryPath + "' to '" + destinationPath + "'");
            FileInfoList fileInfoList = FileInfoList.forDirectory(directoryPath);
            fileInfoList.toXmlFile(destinationPath);
            System.out.println("Done!");
        }
    }
}

