/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.MessageHandler;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.api.console.ConsoleReader;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.HttpUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;

public class LocalEngineRun
implements EngineRun {
    private OperatingSystem operatingSystem;
    private EngineGround engineInfo;
    private MessageHandler messageHandler;
    private String lastMessageId = UUID.randomUUID().toString();
    private boolean shouldStop;

    public LocalEngineRun(OperatingSystem operatingSystem, EngineGround engineInfo) {
        this.operatingSystem = operatingSystem;
        this.engineInfo = engineInfo;
    }

    @Override
    public void runEngine() throws Exception {
        if (!this.operatingSystem.isEngineRunning(this.engineInfo.getEngineId())) {
            System.out.println(this.operatingSystem.runEngine(this.engineInfo.getFile()));
        }
    }

    @Override
    public void stopEngine(UserInfo userInfo) throws Exception {
        String url = this.getURL() + "/stop";
        if (userInfo == null) {
            HttpUtils.openURL((String)url, (boolean)false);
        } else {
            HttpUtils.sendBytes((String)url, (byte[])userInfo.getXml().getBytes(StandardCharsets.UTF_8));
        }
    }

    private String getURL() {
        return "http://localhost:" + this.engineInfo.getPort();
    }

    @Override
    public EngineProcessState getState() throws Exception {
        boolean running = this.operatingSystem.isEngineRunning(this.engineInfo.getEngineId());
        if (running) {
            String isStarted;
            try {
                isStarted = HttpUtils.openURL((String)(this.getURL() + "/isStarted"), (boolean)false);
            }
            catch (Exception e) {
                return EngineProcessState.STARTING;
            }
            if (isStarted != null && isStarted.equals("true")) {
                return EngineProcessState.STARTED;
            }
            return EngineProcessState.STARTING;
        }
        return EngineProcessState.STOPPED;
    }

    @Override
    public void killEngine() throws Exception {
        this.operatingSystem.killEngine(this.engineInfo.getEngineId());
    }

    @Override
    public void deleteEngine() {
        this.finish();
        this.engineInfo.deleteEngine();
    }

    @Override
    public void executeEngineCommand(String command) throws Exception {
        this.operatingSystem.executeEngineCommand(this.engineInfo.getFile(), command);
    }

    @Override
    public List<Message> getConsole(String lastMessageId) throws Exception {
        return ConsoleReader.getConsole(this.engineInfo.getFile(), lastMessageId);
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        return HttpUtils.sendBytes((String)(this.getURL() + "/handleStepRequest/" + boxId), (byte[])o);
    }

    @Override
    public void registerHandler(final MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!LocalEngineRun.this.shouldStop) {
                        List<Message> messages = LocalEngineRun.this.getConsole(LocalEngineRun.this.lastMessageId);
                        for (Message message : messages) {
                            messageHandler.message(message.getValue(), message.getType());
                            LocalEngineRun.this.lastMessageId = message.getId();
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void finish() {
        this.shouldStop = true;
    }

    @Override
    public void backupData(String backupDestDirectory) throws Exception {
        File backupDir = new File(backupDestDirectory);
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        FileUtils.copyDirDeep((String)this.getRoot().getAbsolutePath(), (String)backupDestDirectory);
    }

    @Override
    public File getRoot() {
        return this.engineInfo.getFile();
    }

    @Override
    public byte[] readFile(String name) throws Exception {
        return this.engineInfo.readFile(name);
    }

    @Override
    public String getEngineId() {
        return this.engineInfo.getEngineId();
    }

    public void verifyRelease() throws Exception {
        this.operatingSystem.verifyRelease(this.engineInfo.getFile());
    }
}

