/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.console;

import com.browsersoft.config.api.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;

public class ConsoleReader {
    private static final String CONSOLE_FILE_NAME = "console";
    private static final ConsoleReader instance = new ConsoleReader();
    private File console1;
    private File console2;
    private File newerFile;

    private ConsoleReader() {
    }

    public static void main(String[] args) throws Exception {
        String fileParentPath = "/Users/vmusil/workspace/hie-engine/run/";
        List<Message> out = ConsoleReader.getConsole(new File(fileParentPath), "");
        System.out.println(out.size());
        out.stream().forEach(msg -> System.out.println(msg.toString()));
    }

    public static List<Message> getConsole(File parentFile, String lastMessageId) throws Exception {
        instance.initFiles(parentFile);
        instance.determineActiveFile();
        return instance.readMessages(lastMessageId);
    }

    private void initFiles(File parentFile) {
        this.console1 = new File(parentFile, "console1.out");
        this.console2 = new File(parentFile, "console2.out");
    }

    private void determineActiveFile() {
        this.newerFile = !this.console1.exists() && !this.console2.exists() ? null : (this.console1.exists() && !this.console2.exists() ? this.console1 : (!this.console1.exists() && this.console2.exists() ? this.console2 : (this.console1.lastModified() > this.console2.lastModified() ? this.console1 : this.console2)));
    }

    private List<Message> readMessages(String lastMessageId) throws Exception {
        if (this.newerFile == null) {
            return new ArrayList<Message>();
        }
        if (lastMessageId == null || lastMessageId.trim().isEmpty()) {
            return this.getAllExistingMessages();
        }
        List<Message> messages = ConsoleReader.getMessagesFromFile(this.newerFile, lastMessageId, false);
        if (messages != null) {
            return messages;
        }
        File olderFile = this.getOlderFile();
        if (olderFile == null) {
            return ConsoleReader.getMessagesFromFile(this.newerFile, "", true);
        }
        messages = ConsoleReader.getMessagesFromFile(olderFile, lastMessageId, false);
        if (messages != null) {
            messages.addAll(ConsoleReader.getMessagesFromFile(this.newerFile, lastMessageId, true));
            return messages;
        }
        return this.getAllExistingMessages();
    }

    private List<Message> getAllExistingMessages() throws Exception {
        List<Message> newerMsgs;
        ArrayList<Message> messages = new ArrayList<Message>();
        List<Message> olderMsgs = ConsoleReader.getMessagesFromFile(this.getOlderFile(), "", true);
        if (olderMsgs != null) {
            messages.addAll(olderMsgs);
        }
        if ((newerMsgs = ConsoleReader.getMessagesFromFile(this.newerFile, "", true)) != null) {
            messages.addAll(newerMsgs);
        }
        return messages;
    }

    private File getOlderFile() {
        return this.newerFile == this.console1 ? this.console2 : this.console1;
    }

    private static List<Message> getMessagesFromFile(File file, String lastMessageId, boolean ignoreLastMessageId) throws Exception {
        int nextChar;
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        if (!ignoreLastMessageId && (lastMessageId == null || lastMessageId.trim().isEmpty())) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, "#-#&&#-#".length());
        ArrayList<Message> messages = new ArrayList<Message>();
        StringBuilder lineSB = new StringBuilder();
        boolean found = ignoreLastMessageId;
        while ((nextChar = pushbackInputStream.read()) >= 0) {
            if (nextChar == 35 && ConsoleReader.isMessage(pushbackInputStream, nextChar)) {
                String line = lineSB.toString();
                line = line.startsWith("\n") ? line.substring(1) : line;
                String[] s = line.split("-#@#-");
                Message message = new Message(s[0], s[1], s[2]);
                if (found) {
                    messages.add(message);
                } else if (line.startsWith(lastMessageId)) {
                    found = true;
                }
                lineSB = new StringBuilder();
                continue;
            }
            lineSB.append((char)nextChar);
        }
        fileInputStream.close();
        return found ? messages : null;
    }

    private static boolean isMessage(PushbackInputStream pushBackInputStream, int first) throws IOException {
        pushBackInputStream.unread(first);
        byte[] bytes = new byte["#-#&&#-#".length()];
        int ret = pushBackInputStream.read(bytes);
        if (ret == -1) {
            return false;
        }
        if (new String(bytes, "UTF-8").equals("#-#&&#-#")) {
            return true;
        }
        pushBackInputStream.unread(bytes, 1, "#-#&&#-#".length() - 1);
        return false;
    }
}

