/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.ModuleType;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.HashException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EngineModule
implements Serializable {
    private String name;
    private String description;
    private final String id;
    private final ModuleType type;
    private String config;
    private String settings;
    private String hash;
    private final List<String> strongDependencies = new ArrayList<String>();
    private static final String SPLIT = "#####=######%%%%######=####";

    public EngineModule(String moduleId, ModuleType type, String config, String setting) {
        this.id = moduleId;
        this.type = type;
        this.config = config;
        this.settings = setting;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModuleType getType() {
        return this.type;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getSettings() {
        return this.settings;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public void addStrongDependency(String dependency) {
        this.strongDependencies.add(dependency);
    }

    public List<String> getStrongDependencies() {
        return this.strongDependencies;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void beforeSerialisation() throws HashException {
        this.hash = Hash.toHex((byte[])Hash.forString((String)this.toFileContent()));
        this.config = null;
        this.settings = null;
    }

    public String toFileContent() {
        return this.config + SPLIT + this.settings;
    }

    public void fromFileContent(String value) {
        String[] values = value.split(SPLIT);
        this.config = values[0];
        this.settings = values[1];
    }

    public boolean isClassType() {
        return this.type == ModuleType.CLASS;
    }
}

