/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class JpsManager {
    private static final long DATA_TTL = 1000L;
    private static final long TIMEOUT_SECONDS = 5000L;
    private static final Logger logger = Logger.getLogger(JpsManager.class.getName());
    private static final String ENGINE_CLASSNAME = "com.browsersoft.medicalflow.MedicalBoxManager";
    private static boolean initialized = false;
    private static String javaBinPath = "";
    private static Map<String, String> javaProcessArguments;
    private static long lastLoad;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String javaBinPath) {
        Class<JpsManager> clazz = JpsManager.class;
        synchronized (JpsManager.class) {
            if (initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            initialized = true;
            JpsManager.javaBinPath = javaBinPath;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findEnginePid(String engineId) throws IOException, InterruptedException {
        Class<JpsManager> clazz = JpsManager.class;
        synchronized (JpsManager.class) {
            Map<String, String> data = JpsManager.getJavaProcessArguments();
            // ** MonitorExit[clazz] (shouldn't be in output)
            for (Map.Entry entry : data.entrySet()) {
                if (!((String)entry.getValue()).contains(engineId)) continue;
                return (String)entry.getKey();
            }
            return null;
        }
    }

    private static Map<String, String> getJavaProcessArguments() throws IOException, InterruptedException {
        if (System.currentTimeMillis() - 1000L > lastLoad) {
            JpsManager.loadData();
        } else {
            logger.fine("Data loaded from cache.");
        }
        return javaProcessArguments;
    }

    private static void loadData() throws IOException, InterruptedException {
        block3: {
            String jpsCmd = javaBinPath;
            if (!(jpsCmd.isEmpty() || jpsCmd.endsWith("/") || jpsCmd.endsWith("\\"))) {
                jpsCmd = jpsCmd + File.separator;
            }
            jpsCmd = jpsCmd + "jps";
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            Process process = builder.command(jpsCmd, "-lm").start();
            try {
                FutureTask<Map> task = new FutureTask<Map>(() -> JpsManager.parseJps(process));
                Executors.newCachedThreadPool().submit(task);
                javaProcessArguments = task.get(5000L, TimeUnit.MILLISECONDS);
                lastLoad = System.currentTimeMillis();
            }
            catch (ExecutionException | TimeoutException e) {
                logger.fine("Timeout reading jps");
                if (!process.isAlive()) break block3;
                process.destroyForcibly();
            }
        }
    }

    private static Map<String, String> parseJps(Process process) throws IOException {
        long start = System.currentTimeMillis();
        HashMap<String, String> localProcessArguments = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(ENGINE_CLASSNAME)) continue;
                String[] parts = line.trim().split(" ", 3);
                String lvmid = parts[0].trim();
                String args = parts[2].trim();
                logger.finest("Found '" + lvmid + "' -> '" + args + "', time " + new Date());
                localProcessArguments.put(lvmid, args);
            }
        }
        logger.finest("jps processed in " + (System.currentTimeMillis() - start) + " ms.");
        return localProcessArguments;
    }

    static {
        lastLoad = 0L;
    }
}

