/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.api.release.ReleaseVerificationException;
import com.browsersoft.config.api.release.ReleaseVerifier;
import com.browsersoft.config.api.system.BatchClassPathExtractor;
import com.browsersoft.config.api.system.JpsManager;
import com.browsersoft.config.api.system.UnixOperatingSystem;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.HashException;
import com.browsersoft.config.utils.RuntimeUtils;
import com.browsersoft.config.utils.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

public abstract class OperatingSystem {
    private String javaBinDir = "";
    private String oracleLibraryDir = "";
    private String oracleDriverPath = "";

    protected abstract String[] getCommandForKill(String var1);

    protected abstract String getClassPathSeparator();

    protected abstract String getExtensionForBatch();

    protected abstract String getArgumentPrefix();

    public void init(String javaBinDir, String oracleLibraryDir, String oracleDriverPath) {
        this.javaBinDir = javaBinDir;
        this.oracleLibraryDir = oracleLibraryDir;
        if (oracleLibraryDir != null && oracleLibraryDir.isEmpty()) {
            this.oracleLibraryDir = null;
        }
        this.oracleDriverPath = oracleDriverPath;
        if (oracleDriverPath != null && oracleDriverPath.isEmpty()) {
            this.oracleDriverPath = null;
        }
        JpsManager.init(javaBinDir);
    }

    public void killEngine(String engineId) throws Exception {
        String processId = this.findOutProcessId(engineId);
        if (processId != null) {
            String[] command = this.getCommandForKill(processId);
            RuntimeUtils.runCmdSync((String[])command, null, (File)new File("."));
        }
    }

    public boolean isEngineRunning(String engineId) throws Exception {
        return this.findOutProcessId(engineId) != null;
    }

    private String findOutProcessId(String engineId) throws Exception {
        if (engineId == null) {
            return null;
        }
        return JpsManager.findEnginePid(engineId);
    }

    public void createScripts(String engineId, File destination, String root, String persistentRoot, List<String> files, boolean relative, String javaOpts) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String java = "java";
        if (this.javaBinDir != null && !this.javaBinDir.equals("")) {
            java = "\"" + new File(this.javaBinDir, "java").getAbsolutePath() + "\"";
        }
        if (javaOpts == null) {
            javaOpts = "-Xmx2048M -XX:PermSize=512M";
        }
        stringBuilder.append(java).append(" ").append(javaOpts).append(" ").append("-Duser.timezone=UTC").append(" ").append("-Djava.awt.headless=true");
        if (this.oracleLibraryDir != null) {
            stringBuilder.append(" -Djava.library.path=").append("\"").append(this.oracleLibraryDir).append("\"");
        }
        stringBuilder.append(" ").append("-cp").append(" ").append(this.createRelativeClassPath(destination, files)).append(" ").append("com.browsersoft.medicalflow.MedicalBoxManager").append(" ").append("\"").append(root).append("\"").append(" ").append("\"").append(persistentRoot).append("\"").append(" ").append("\"").append(engineId).append("\"");
        FileUtils.saveBytesToFile((File)new File(destination, "run." + this.getExtensionForBatch()), (byte[])stringBuilder.toString().getBytes());
        stringBuilder = new StringBuilder();
        stringBuilder.append(java).append(" ").append("-cp").append(" ").append("engine_control/api.jar").append(this.getClassPathSeparator()).append("engine_control/utils.jar").append(this.getClassPathSeparator()).append("engine_control/commons-exec.jar").append(this.getClassPathSeparator()).append("engine_control/commons-cli.jar").append(this.getClassPathSeparator()).append("engine_control/worlds_binding.jar").append(this.getClassPathSeparator()).append("engine_control/xercesImpl.jar").append(" ").append("com.browsersoft.config.api.control.ControlProcess").append(" ").append(this.getArgumentPrefix()).append("*");
        FileUtils.saveBytesToFile((File)new File(destination, "hieengine." + this.getExtensionForBatch()), (byte[])stringBuilder.toString().getBytes());
        File dir = new File(destination, "engine_control");
        dir.mkdir();
        this.copyJar(dir, "api.jar");
        this.copyJar(dir, "utils.jar");
        this.copyJar(dir, "worlds_binding.jar");
        this.copyJar(dir, "commons-exec.jar");
        this.copyJar(dir, "commons-cli.jar");
        this.copyJar(dir, "xercesImpl.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJar(File root, String jarName) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = OperatingSystem.class.getResourceAsStream("/com/browsersoft/config/api/jars/" + jarName);
            if (inputStream == null) {
                throw new IOException("Can`t find jar " + jarName + " in the /com/browsersoft/config/api/jars/ path." + "Try to run publish-all ant task.");
            }
            outputStream = new FileOutputStream(new File(root, jarName));
            StreamUtils.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String runScript(File root, String name) throws Exception {
        return this.runScript(root, name, null);
    }

    public String runScript(File root, String name, String appendCmd) throws Exception {
        File file = new File(root, name);
        String s = new String(FileUtils.loadFileToBytes((File)file), "UTF-8");
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (this instanceof UnixOperatingSystem && this.oracleLibraryDir != null && !this.oracleLibraryDir.isEmpty()) {
            String ldPath = env.getOrDefault("LD_LIBRARY_PATH", "");
            if (ldPath.isEmpty()) {
                env.put("LD_LIBRARY_PATH", this.oracleLibraryDir);
            } else if (!ldPath.contains(this.oracleLibraryDir)) {
                env.put("LD_LIBRARY_PATH", ldPath + ":" + this.oracleLibraryDir);
            }
        }
        if (appendCmd != null && !appendCmd.isEmpty()) {
            s = s + appendCmd;
        }
        return RuntimeUtils.runCmdSync((String)s, env, (File)root);
    }

    public String runScriptNatively(File root, String name) throws Exception {
        String[] command = new String[]{"./" + name};
        return RuntimeUtils.runCmdSync((String[])command, null, (File)root);
    }

    public String runEngine(File root) throws Exception {
        return this.runScript(root, "./run." + this.getExtensionForBatch());
    }

    public String executeEngineCommand(File root, String command) throws Exception {
        return this.runScript(root, "./run." + this.getExtensionForBatch(), " " + command);
    }

    public String createRelativeClassPath(File root, List<String> files) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = files.iterator();
        while (iterator.hasNext()) {
            String file = iterator.next();
            Path filepath = Paths.get(file, new String[0]);
            String filename = filepath.getFileName().toString();
            if (this.oracleDriverPath != null && !this.oracleDriverPath.equals("") && filename.matches("^ojdbc\\d+.*$")) {
                stringBuilder.append(this.oracleDriverPath);
            } else {
                Path secondPath = Paths.get(root.getAbsolutePath(), new String[0]);
                String path = secondPath.relativize(filepath).toString();
                stringBuilder.append(path.replace('\\', '/'));
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.getClassPathSeparator());
        }
        return stringBuilder.toString();
    }

    public void verifyRelease(File root) throws IOException, HashException, ReleaseVerificationException, SAXException, CertificateException {
        File batchFile = new File(root, "run." + this.getExtensionForBatch());
        List<JarRecord> jars = BatchClassPathExtractor.getJars(batchFile);
        ReleaseVerifier.verify(jars);
    }
}

