/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.system.OperatingSystem;
import java.io.File;
import java.util.List;

public class UnixOperatingSystem
extends OperatingSystem {
    @Override
    protected String[] getCommandForKill(String pid) {
        return new String[]{"kill", "-9", pid};
    }

    @Override
    protected String getClassPathSeparator() {
        return ":";
    }

    @Override
    protected String getExtensionForBatch() {
        return "sh";
    }

    @Override
    public void createScripts(String engineId, File destination, String root, String persistentRoot, List<String> files, boolean relative, String javaOpts) throws Exception {
        super.createScripts(engineId, destination, root, persistentRoot, files, relative, javaOpts);
        new File(destination, "run.sh").setExecutable(true);
        new File(destination, "hieengine.sh").setExecutable(true);
    }

    @Override
    protected String getArgumentPrefix() {
        return "$";
    }
}

