/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class SynchronizedFileWriter {
    private File file;
    private FileOutputStream out;
    private FileChannel outChannel;

    public SynchronizedFileWriter(File file) throws IOException {
        this(file, false);
    }

    public SynchronizedFileWriter(File file, boolean closeOnShutdown) throws IOException {
        this.file = file;
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        this.out = new FileOutputStream(file, true);
        this.outChannel = this.out.getChannel();
        if (closeOnShutdown) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SynchronizedFileWriter.this.close();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) throws IOException {
        SynchronizedFileWriter synchronizedFileWriter = this;
        synchronized (synchronizedFileWriter) {
            if (this.outChannel == null) {
                return;
            }
            this.outChannel.write(ByteBuffer.wrap(s.getBytes()));
            this.outChannel.force(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SynchronizedFileWriter synchronizedFileWriter = this;
        synchronized (synchronizedFileWriter) {
            try {
                this.outChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outChannel = null;
            this.out = null;
            this.file = null;
        }
    }
}

