/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.tableinfo;

import com.browsersoft.config.utils.tableinfo.TableFieldInfoUtils;
import com.browsersoft.config.utils.tableinfo.TableInfo;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class TableInfoModel {
    private Map<Class, TableInfo> tables = new HashMap<Class, TableInfo>();
    private ComboPooledDataSource dataSource;

    public TableInfoModel(ComboPooledDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void registerClass(Class clazz) throws Exception {
        this.tables.put(clazz, TableFieldInfoUtils.getTableInfo(clazz, "parent"));
    }

    public void registerClass(Class clazz, String parentId) throws Exception {
        this.tables.put(clazz, TableFieldInfoUtils.getTableInfo(clazz, parentId));
    }

    public boolean ensureStructure() throws SQLException {
        return true;
    }

    public <T> long createEntity(T record) throws Exception {
        return TableFieldInfoUtils.createEntity(this.dataSource, record, this.tables.get(record.getClass()));
    }

    public <T> List<T> getEntitiesWithLimit(T record, String orderField, int from, int size) throws Exception {
        return TableFieldInfoUtils.getEntitiesWithLimit(this.dataSource, this.tables.get(record.getClass()), orderField, from, size);
    }

    public <T> void updateEntity(T record) throws Exception {
        TableFieldInfoUtils.updateEntity(this.dataSource, record, this.tables.get(record.getClass()));
    }

    public <T> void updateEntityWhereFieldStringEquals(T record, String fieldName, String fieldValue) throws Exception {
        TableFieldInfoUtils.updateEntityWhereFieldStringEquals(this.dataSource, record, this.tables.get(record.getClass()), fieldName, fieldValue);
    }

    public void deleteEntity(Class clazz, long id) throws Exception {
        TableFieldInfoUtils.deleteEntity(this.dataSource, this.tables.get(clazz), id);
    }

    public void deleteEntityWhereFieldStringEquals(Class clazz, String fieldName, String fieldValue) throws Exception {
        TableFieldInfoUtils.deleteEntityWhereFieldStringEquals(this.dataSource, this.tables.get(clazz), fieldName, fieldValue);
    }

    public <T> List<T> getEntities(Class clazz, long parent) throws Exception {
        return TableFieldInfoUtils.getEntities(this.dataSource, this.tables.get(clazz), parent);
    }

    public List<String> getOneColumnForAllEntities(Class clazz, String columnName) throws Exception {
        return TableFieldInfoUtils.getOneColumnForAllEntities(this.dataSource, this.tables.get(clazz), columnName);
    }

    public <T> List<T> getEntitiesWhereFieldStringEquals(Class clazz, String name, String parent) throws Exception {
        return TableFieldInfoUtils.getEntitiesWhereFieldStringEquals(this.dataSource, this.tables.get(clazz), name, parent);
    }

    public <T> T getEntity(Class clazz, long id) throws Exception {
        return TableFieldInfoUtils.getEntity(this.dataSource, this.tables.get(clazz), id);
    }

    public <T> T getEntityWhereFieldStringEquals(Class clazz, String fieldName, String fieldValue) throws Exception {
        return TableFieldInfoUtils.getEntityWhereFieldStringEquals(this.dataSource, this.tables.get(clazz), fieldName, fieldValue);
    }

    public <T> boolean existEntityWhereFieldStringEquals(Class clazz, String fieldName, String fieldValue) throws Exception {
        return TableFieldInfoUtils.existsEntityWhereFieldStringEquals(this.dataSource, this.tables.get(clazz), fieldName, fieldValue);
    }

    public void moveEntity(Class clazz, long id, long parent) throws Exception {
        TableFieldInfoUtils.moveEntity(this.dataSource, this.tables.get(clazz), id, parent);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public TableInfo getTableInfo(Class clazz) {
        return this.tables.get(clazz);
    }
}

